/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.util.BitArray;

public class BitArrayTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Class)BitArrayTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public BitArrayTest(String arg0) {
        super(arg0);
    }

    public void testLength() {
        BitArray ba = new BitArray();
        BitArrayTest.assertTrue((ba.length() == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 64; ++i) {
            ba.set(i, false);
            BitArrayTest.assertTrue((ba.length() == i + 1 ? 1 : 0) != 0);
        }
    }

    public void testSet() {
        BitArray ba = new BitArray();
        BitArrayTest.assertTrue((ba.length() == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 64; ++i) {
            if (i % 2 == 0) {
                ba.set(i, true);
                BitArrayTest.assertTrue((boolean)ba.get(i));
                continue;
            }
            ba.set(i, false);
            BitArrayTest.assertTrue((!ba.get(i) ? 1 : 0) != 0);
        }
    }

    public void testWriteToStream() {
        try {
            for (int i = 0; i < 64; ++i) {
                this.testWrite(i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void testWrite(int size) throws IOException {
        BitArray ba = new BitArray();
        for (int i = 0; i < size; ++i) {
            if (i % 2 == 0) {
                ba.set(i, true);
                continue;
            }
            ba.set(i, false);
        }
        byte[] data = this.getData(ba);
        ba = new BitArray();
        this.setData(ba, data);
        BitArrayTest.assertTrue((ba.length() == size ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            if (i % 2 == 0) {
                BitArrayTest.assertTrue((boolean)ba.get(i));
                continue;
            }
            BitArrayTest.assertTrue((!ba.get(i) ? 1 : 0) != 0);
        }
    }

    public void testTime() throws IOException {
        int count = 100000;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            BitArray ba = new BitArray();
            for (int j = 0; j < 64; ++j) {
                if (j % 2 == 0) {
                    ba.set(j, true);
                    continue;
                }
                ba.set(j, false);
            }
            byte[] data = this.getData(ba);
            ba = new BitArray();
            this.setData(ba, data);
        }
        long finishTime = System.currentTimeMillis();
        long totalTime = finishTime - startTime;
        long ps = (long)(count * 1000) / totalTime;
        System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
    }

    byte[] getData(BitArray ba) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        ba.writeToStream((DataOutput)dataOut);
        dataOut.flush();
        return bytesOut.toByteArray();
    }

    void setData(BitArray ba, byte[] data) throws IOException {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
        DataInputStream dataIn = new DataInputStream(bytesIn);
        ba.readFromStream((DataInput)dataIn);
    }
}

