/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.impl.BrokerContainerImpl;
import org.activemq.io.WireFormat;
import org.activemq.message.ConnectionInfo;
import org.activemq.message.Packet;
import org.activemq.message.Receipt;
import org.activemq.message.SessionInfo;
import org.activemq.transport.stomp.StompWireFormat;

public class StompWireFormatTest
extends TestCase {
    private StompWireFormat wire;

    public void setUp() throws Exception {
        this.wire = new StompWireFormat();
    }

    public void testValidConnectHandshake() throws Exception {
        String connect_frame = "CONNECT\nlogin: brianm\npasscode: wombats\n\n\u0000";
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(connect_frame.getBytes()));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        this.wire.registerTransportStreams(dout, din);
        this.wire.initiateServerSideProtocol();
        ConnectionInfo ci = (ConnectionInfo)this.wire.readPacket((DataInput)din);
        StompWireFormatTest.assertNotNull((Object)ci);
        StompWireFormatTest.assertTrue((boolean)ci.isReceiptRequired());
        Receipt cr = new Receipt();
        cr.setCorrelationId(ci.getId());
        this.wire.writePacket((Packet)cr, (DataOutput)dout);
        SessionInfo si = (SessionInfo)this.wire.readPacket(null);
        StompWireFormatTest.assertNotNull((Object)si);
        StompWireFormatTest.assertTrue((boolean)si.isReceiptRequired());
        Receipt sr = new Receipt();
        sr.setCorrelationId(si.getId());
        this.wire.writePacket((Packet)sr, (DataOutput)dout);
        String response = new String(bout.toByteArray());
        StompWireFormatTest.assertTrue((boolean)response.startsWith("CONNECTED"));
    }

    public void _testFakeServer() throws Exception {
        BrokerContainerImpl container = new BrokerContainerImpl();
        new Thread(new Runnable((BrokerContainer)container){
            private final /* synthetic */ BrokerContainer val$container;
            {
                this.val$container = val$container;
            }

            public void run() {
                try {
                    this.val$container.addConnector("tcp://127.0.0.1:61613", (WireFormat)new StompWireFormat());
                    this.val$container.start();
                }
                catch (JMSException e) {
                    System.err.println("ARGH");
                }
            }
        }).start();
        System.err.println("started container");
        System.err.println("okay, go play");
        System.err.println(System.in.read());
    }
}

