/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.remote;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.impl.BrokerContainerImpl;

public class RemoteTransportTest
extends TestCase {
    protected BrokerContainer remoteBroker;
    protected Connection producerConnection;
    protected Connection consumerConnection;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Session producerSession;
    private Session consumerSession;

    protected void setUp() throws Exception {
        String URL2 = "reliable://tcp://localhost:61616";
        this.remoteBroker = new BrokerContainerImpl("remoteBroker");
        this.remoteBroker.addConnector("tcp://localhost:61616");
        this.remoteBroker.start();
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("remote://" + URL2);
        this.consumerConnection = fac.createConnection();
        this.consumerConnection.setClientID("receiver");
        this.consumerConnection.start();
        fac = new ActiveMQConnectionFactory("remote://" + URL2 + "?brokerName=sender");
        this.producerConnection = fac.createConnection();
        this.producerConnection.start();
    }

    private void doDurableTestSetup() throws Exception {
        this.consumerSession = this.consumerConnection.createSession(false, 1);
        Topic destination = this.consumerSession.createTopic(this.getName());
        this.consumer = this.consumerSession.createDurableSubscriber(destination, destination.toString());
        this.producerSession = this.producerConnection.createSession(false, 1);
        this.producer = this.producerSession.createProducer((Destination)destination);
    }

    private void doTopicTestSetup() throws Exception {
        this.consumerSession = this.consumerConnection.createSession(false, 1);
        Topic destination = this.consumerSession.createTopic(this.getName());
        this.consumer = this.consumerSession.createConsumer((Destination)destination);
        this.producerSession = this.producerConnection.createSession(false, 1);
        this.producer = this.producerSession.createProducer((Destination)destination);
        this.producer.setDeliveryMode(1);
    }

    private void doQueueTestSetup() throws Exception {
        this.consumerSession = this.consumerConnection.createSession(false, 1);
        Queue destination = this.consumerSession.createQueue(this.getName());
        this.consumer = this.consumerSession.createConsumer((Destination)destination);
        this.producerSession = this.producerConnection.createSession(false, 1);
        this.producer = this.producerSession.createProducer((Destination)destination);
    }

    protected void tearDown() throws Exception {
        this.remoteBroker.stop();
        this.consumerConnection.close();
        this.producerConnection.close();
    }

    public void doTest() throws Exception {
        Message msg;
        int i;
        Thread.sleep(3000L);
        int COUNT = 10;
        ArrayList<Message> list = new ArrayList<Message>(COUNT);
        for (i = 0; i < COUNT; ++i) {
            msg = this.producerSession.createTextMessage("test:" + i);
            this.producer.send(msg);
            list.add(msg);
        }
        for (i = 0; i < COUNT; ++i) {
            msg = this.consumer.receive(1000L);
            RemoteTransportTest.assertNotNull((String)("Receive: " + i + " NO message received!"), (Object)msg);
            Message sentMsg = (Message)list.get(i);
            RemoteTransportTest.assertTrue((String)("count " + i + " unexpected message: " + msg), (boolean)msg.getJMSMessageID().equals(sentMsg.getJMSMessageID()));
        }
        RemoteTransportTest.assertNull((Object)this.consumer.receiveNoWait());
    }

    public void testDurableSendReceive() throws Exception {
        this.doDurableTestSetup();
        this.doTest();
        this.consumerSession.close();
        this.producerSession.close();
        this.doDurableTestSetup();
        this.doTest();
    }

    public void xtestTopicSendReceive() throws Exception {
        this.doTopicTestSetup();
        this.doTest();
    }

    public void xtestQueueSendReceive() throws Exception {
        this.doQueueTestSetup();
        this.doTest();
    }
}

