/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.reliable;

import java.net.URI;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.message.Packet;
import org.activemq.message.ReceiptHolder;
import org.activemq.transport.reliable.KeepAliveDaemon;
import org.activemq.transport.reliable.ReliableTransportChannel;
import org.activemq.transport.reliable.ReliableTransportChannelFactory;

public class KeepAliveDaemonTest
extends TestCase {
    private boolean forced = false;
    private boolean sent = false;
    final long keepAliveTimeout = 1000L;
    final long checkInterval = 500L;

    private void reset() {
        this.sent = false;
        this.forced = false;
    }

    public void testKeepAliveProperty() throws Exception {
        long keepAliveTimeout = 373727L;
        ReliableTransportChannel ch = (ReliableTransportChannel)new ReliableTransportChannelFactory().create((WireFormat)new DefaultWireFormat(), new URI("vm://localhost:6144?keepAliveTimeout=" + keepAliveTimeout));
        KeepAliveDaemonTest.assertEquals((long)ch.getKeepAliveTimeout(), (long)keepAliveTimeout);
    }

    public void testNoDisconnectOnChannelWithNoTimeout() throws Exception {
        ReliableTransportChannelMock channel = new ReliableTransportChannelMock(){

            public long getLastReceiptTimestamp() {
                return 0L;
            }
        };
        channel.setKeepAliveTimeout(0L);
        channel.lastReceiptTime = System.currentTimeMillis();
        KeepAliveDaemon d = new KeepAliveDaemon();
        d.setCheckInterval(500L);
        d.addMonitoredChannel((ReliableTransportChannel)channel);
        d.start();
        this.reset();
        Thread.sleep(2000L);
        KeepAliveDaemonTest.assertFalse((String)"No keep-alive should have been sent since the channel has a zero timeout.", (boolean)this.sent);
        KeepAliveDaemonTest.assertFalse((String)"Should not have been disconnected since channel has a zero timeout.", (boolean)this.forced);
    }

    public void testNoDisconnectOnFreshChannel() throws Exception {
        ReliableTransportChannelMock channel = new ReliableTransportChannelMock(){

            public long getLastReceiptTimestamp() {
                return System.currentTimeMillis();
            }
        };
        channel.setKeepAliveTimeout(1000L);
        KeepAliveDaemon d = new KeepAliveDaemon();
        d.setCheckInterval(500L);
        d.addMonitoredChannel((ReliableTransportChannel)channel);
        d.start();
        this.reset();
        Thread.sleep(1000L);
        KeepAliveDaemonTest.assertFalse((String)"No keep-alive should have been sent since this channel has a fresh timestamp.", (boolean)this.sent);
        KeepAliveDaemonTest.assertFalse((String)"Should NOT have been forced to disconnect.", (boolean)this.forced);
    }

    public void testForcedDisconnect() throws Exception {
        final KeepAliveDaemon d = new KeepAliveDaemon();
        ReliableTransportChannelMock channel = new ReliableTransportChannelMock(){

            public long getLastReceiptTimestamp() {
                return d.getLastCheckTime() - 2000L - 1L;
            }
        };
        channel.setKeepAliveTimeout(1000L);
        d.setCheckInterval(500L);
        d.addMonitoredChannel((ReliableTransportChannel)channel);
        d.start();
        Thread.sleep(500L);
        KeepAliveDaemonTest.assertTrue((String)"KeepAlive packet should have been sent", (boolean)this.sent);
        KeepAliveDaemonTest.assertFalse((String)"Should NOT have been forced to disconnect yet.", (boolean)this.forced);
        this.reset();
        Thread.sleep(500L);
        KeepAliveDaemonTest.assertTrue((String)"Should have been forced to disconnect.", (boolean)this.forced);
    }

    public void testIdleChannelThatRespondsInTime() throws Exception {
        ReliableTransportChannelMock channel = new ReliableTransportChannelMock();
        channel.setKeepAliveTimeout(1000L);
        channel.lastReceiptTime = System.currentTimeMillis() - 1000L;
        KeepAliveDaemon d = new KeepAliveDaemon();
        d.setCheckInterval(500L);
        d.addMonitoredChannel((ReliableTransportChannel)channel);
        d.start();
        Thread.sleep(750L);
        KeepAliveDaemonTest.assertTrue((String)"KeepAlive packet should have been sent", (boolean)this.sent);
        KeepAliveDaemonTest.assertFalse((String)"Should NOT have been forced to disconnect yet.", (boolean)this.forced);
        this.reset();
        channel.lastReceiptTime = System.currentTimeMillis() + 500L;
        Thread.sleep(500L);
        KeepAliveDaemonTest.assertFalse((String)"Should NOT have been forced to disconnect since the new timestamp is fresh enough.", (boolean)this.forced);
    }

    public void testStoppedChannelsAreStoppedBeingMonitored() throws Exception {
        ReliableTransportChannelMock channel = new ReliableTransportChannelMock(){

            public long getLastReceiptTimestamp() {
                return 0L;
            }
        };
        channel.setKeepAliveTimeout(1000L);
        channel.lastReceiptTime = System.currentTimeMillis();
        KeepAliveDaemon d = new KeepAliveDaemon();
        d.setCheckInterval(500L);
        d.addMonitoredChannel((ReliableTransportChannel)channel);
        d.start();
        channel.doClose();
        Thread.sleep(750L);
        KeepAliveDaemonTest.assertFalse((String)"No keep-alive should have been sent since the channel is stopped.", (boolean)this.sent);
        KeepAliveDaemonTest.assertFalse((String)"Should NOT have been forced to disconnect.", (boolean)this.forced);
    }

    protected class ReliableTransportChannelMock
    extends ReliableTransportChannel {
        private boolean stopped;
        protected long lastReceiptTime;

        protected ReliableTransportChannelMock() {
            super((WireFormat)new DefaultWireFormat());
            this.stopped = false;
            this.lastReceiptTime = 0L;
        }

        public ReceiptHolder asyncSendWithReceipt(Packet packet) throws JMSException {
            KeepAliveDaemonTest.this.sent = true;
            return null;
        }

        public void forceDisconnect() {
            KeepAliveDaemonTest.this.forced = true;
        }

        public void start() throws JMSException {
        }

        public void doClose() {
            super.doClose();
            this.stopped = true;
        }

        public long getLastReceiptTimestamp() {
            return this.lastReceiptTime;
        }

        public boolean isTransportConnected() {
            return !this.stopped;
        }
    }
}

