/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.activeio;

import java.io.IOException;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.test.TestSupport;
import org.activemq.transport.activeio.ActiveIOTransportChannel;

public class ExceptionListenerTest
extends TestSupport
implements ExceptionListener {
    protected Connection connection;
    protected JMSException exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailingConnection() throws Exception {
        this.breakTransport();
        ExceptionListenerTest exceptionListenerTest = this;
        synchronized (exceptionListenerTest) {
            if (this.exception == null) {
                ((Object)((Object)this)).wait(3000L);
            }
        }
        ExceptionListenerTest.assertTrue((String)"Should have been notified of an exception", (this.exception != null ? 1 : 0) != 0);
    }

    public synchronized void onException(JMSException e) {
        System.out.println("Caught exception: " + (Object)((Object)e));
        this.exception = e;
        ((Object)((Object)this)).notifyAll();
    }

    protected void breakTransport() throws IOException, JMSException {
        ActiveIOTransportChannel transport = (ActiveIOTransportChannel)((ActiveMQConnection)this.connection).getTransportChannel();
        transport.getAsynchChannel().dispose();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setUseEmbeddedBroker(true);
        factory.setBrokerURL(this.getURL());
        return factory;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
        this.connection.setExceptionListener((ExceptionListener)this);
        System.out.println("Created connection: " + this.connection);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                System.out.println("Failed to close connection: " + (Object)((Object)e));
                e.printStackTrace();
            }
        }
        super.tearDown();
    }

    protected String getURL() {
        return "activeio:socket://localhost:62345";
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ExceptionListenerTest.class);
        suite.addTestSuite(VMPipeExceptionListenerTest.class);
        suite.addTestSuite(NIOExceptionListenerTest.class);
        return suite;
    }

    public static class NIOExceptionListenerTest
    extends ExceptionListenerTest {
        protected String getURL() {
            return "activeio:nio://localhost:62345";
        }
    }

    public static class VMPipeExceptionListenerTest
    extends ExceptionListenerTest {
        protected String getURL() {
            return "activeio:vmpipe://localhost";
        }
    }
}

