/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import java.net.URI;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.transport.TransportChannelProvider;
import org.activemq.transport.composite.CompositeTransportChannel;
import org.activemq.transport.vm.VmTransportChannel;

public class UriParseTest
extends TestCase {
    protected CompositeTransportChannel channel;
    protected WireFormat wireFormat = new DefaultWireFormat();

    public void testSingleURI() throws Exception {
        this.assertVmSendCapacity("list:vm://foo?sendCapacity=999,vm://bar?sendCapacity=999", 999);
    }

    public void testMultipleURIs() throws Exception {
        this.assertVmSendCapacity("list:vm://foo?sendCapacity=999", 999);
    }

    public void testPropertiesOnCompositeChannel() throws Exception {
        this.assertVmSendCapacity("list:(vm://foo?sendCapacity=999)?maximumRetries=123", 999);
        UriParseTest.assertEquals((String)"Composite channel maximumRetries", (int)123, (int)this.channel.getMaximumRetries());
    }

    public void testPropertiesOnReliableChannel() throws Exception {
        this.assertVmSendCapacity("reliable:(vm://foo?sendCapacity=999)?maximumRetries=123", 999);
        UriParseTest.assertEquals((String)"Composite channel maximumRetries", (int)123, (int)this.channel.getMaximumRetries());
    }

    protected void assertVmSendCapacity(String uriText, int sendCapacity) throws JMSException, InterruptedException {
        URI uri = URI.create(uriText);
        this.channel = (CompositeTransportChannel)TransportChannelProvider.create((WireFormat)this.wireFormat, (URI)uri);
        this.channel.start();
        for (int i = 0; i < 100; ++i) {
            try {
                this.channel.getChannel();
                break;
            }
            catch (JMSException e) {
                Thread.sleep(100L);
                continue;
            }
        }
        VmTransportChannel subChannel = (VmTransportChannel)this.channel.getChannel();
        UriParseTest.assertNotNull((String)"VM channel exists", (Object)subChannel);
        UriParseTest.assertEquals((String)("sendCapacity for uri: " + uriText), (int)sendCapacity, (int)subChannel.getSendCapacity());
    }

    protected void tearDown() throws Exception {
        if (this.channel != null) {
            this.channel.stop();
        }
    }
}

