/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import EDU.oswego.cs.dl.util.concurrent.Slot;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.KeepAlive;
import org.activemq.message.Packet;
import org.activemq.message.PacketListener;
import org.activemq.message.Receipt;
import org.activemq.message.ReceiptHolder;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.TransportChannelListener;
import org.activemq.transport.TransportChannelProvider;
import org.activemq.transport.TransportServerChannel;
import org.activemq.transport.TransportServerChannelProvider;
import org.activemq.transport.TransportStatusEvent;
import org.activemq.transport.TransportStatusEventListener;
import org.activemq.util.IdGenerator;

public class TransportChannelTestSupport
extends TestCase
implements PacketListener,
TransportChannelListener {
    protected int TEST_SIZE = 100;
    protected Object mutex;
    protected TransportChannel sender;
    protected TransportChannel receiver;
    protected TransportServerChannel server;
    protected ArrayList packets;
    protected List exceptions = new Vector();
    protected boolean sendReceipts = false;
    private IdGenerator idGenerator = new IdGenerator();
    protected WireFormat wireFormat = new DefaultWireFormat();
    private boolean closeReceiver = true;

    public TransportChannelTestSupport() {
    }

    public TransportChannelTestSupport(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendPacket() throws Exception {
        int i;
        System.out.println("Sending packets");
        List tmpList = (List)this.packets.clone();
        for (i = 0; i < this.TEST_SIZE; ++i) {
            Packet packet = (Packet)tmpList.get(i);
            this.sender.asyncSend(packet);
        }
        System.out.println("Sent: " + this.TEST_SIZE + " packets");
        for (i = 0; i < 10; ++i) {
            Object object = this.mutex;
            synchronized (object) {
                if (!this.packets.isEmpty()) {
                    this.mutex.wait(500L);
                }
                continue;
            }
        }
        TransportChannelTestSupport.assertTrue((String)("Packets not consumed, still have: " + this.packets.size() + " packet(s) unconsumed"), (boolean)this.packets.isEmpty());
        TransportChannelTestSupport.assertTrue((String)("Exceptions were thrown: " + this.exceptions), (this.exceptions.size() == 0 ? 1 : 0) != 0);
    }

    public void testAsyncSendWithReceipt() throws Exception {
        this.sendReceipts = true;
        KeepAlive packet = new KeepAlive();
        packet.setId((short)1);
        ReceiptHolder rh = this.sender.asyncSendWithReceipt((Packet)packet);
        Receipt result = rh.getReceipt(5000);
        if (result == null) {
            TransportChannelTestSupport.fail((String)"Should have gotten receipt");
        }
    }

    public void testRpc() throws Exception {
        this.sendReceipts = true;
        List tmpList = (List)this.packets.clone();
        for (int i = 0; i < this.TEST_SIZE; ++i) {
            Packet packet = (Packet)tmpList.get(i);
            Receipt receipt = this.sender.send(packet, 4000);
            TransportChannelTestSupport.assertTrue((String)"Receipt should not be null!", (receipt != null ? 1 : 0) != 0);
            System.out.println("Got receipt: " + receipt + " for packet: " + packet);
        }
    }

    public void testForceDisconnect() throws Exception {
        this.sender.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException arg0) {
            }
        });
        if (this.receiver != null) {
            this.receiver.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                }
            });
        }
        this.testAsyncSendWithReceipt();
        final Slot disconnectEvent = new Slot();
        this.sender.addTransportStatusEventListener(new TransportStatusEventListener(){

            public void statusChanged(TransportStatusEvent e) {
                if (e.getChannelStatus() == 2) {
                    try {
                        disconnectEvent.offer((Object)e, 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        this.sender.forceDisconnect();
        TransportChannelTestSupport.assertNotNull((String)"Should have received state change notification", (Object)disconnectEvent.poll(30000L));
        TransportChannelTestSupport.assertFalse((String)"Should be disconnected", (boolean)this.sender.isTransportConnected());
        this.exceptions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Packet packet) {
        System.out.println("Received packet: " + packet);
        if (this.sendReceipts) {
            Receipt receipt = new Receipt();
            receipt.setId(this.idGenerator.getNextShortSequence());
            receipt.setCorrelationId(packet.getId());
            try {
                this.receiver.asyncSend((Packet)receipt);
            }
            catch (JMSException e) {
                this.logMessage("Sending receipt: " + receipt + " for packet: " + packet, e);
            }
        } else {
            this.packets.remove(packet);
            if (this.packets.isEmpty()) {
                Object object = this.mutex;
                synchronized (object) {
                    this.mutex.notify();
                }
            }
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        TransportChannelTestSupport.assertTrue((String)"sender must be constructed in the TestCase before setUp() is invoked", (this.sender != null ? 1 : 0) != 0);
        TransportChannelTestSupport.assertTrue((String)"receiver or server must be constructed in the TestCase before setUp() is invoked", (this.receiver != null || this.server != null ? 1 : 0) != 0);
        this.mutex = new Object();
        this.sender.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException ex) {
                String message = "Sender got an exception:";
                TransportChannelTestSupport.this.logMessage(message, ex);
            }
        });
        this.sender.setPacketListener(new PacketListener(){

            public void consume(Packet packet) {
                System.err.println("Error - sender received a packet: " + packet);
                TransportChannelTestSupport.this.exceptions.add(packet);
            }
        });
        this.sender.setClientID("sender");
        this.sender.start();
        this.packets = new ArrayList(this.TEST_SIZE);
        for (int i = 0; i < this.TEST_SIZE; ++i) {
            ActiveMQMessage test = new ActiveMQMessage();
            test.setJMSMessageID("test:" + i);
            test.setExternalMessageId(true);
            test.setJMSDestination((Destination)new ActiveMQTopic(this.getName()));
            this.packets.add(test);
        }
    }

    protected void tearDown() throws Exception {
        if (this.receiver != null) {
            this.receiver.setExceptionListener(null);
        }
        super.tearDown();
        System.out.println("Stopping sender");
        this.sender.stop();
        if (this.receiver == null) {
            System.out.println("No receiver created!");
        } else if (this.closeReceiver) {
            System.out.println("Stopping receiver");
            this.receiver.stop();
        } else {
            System.out.println("Receiver will be closed by the server");
        }
        if (this.server != null) {
            System.out.println("Stopping server");
            this.server.stop();
        }
        TransportChannelTestSupport.assertTrue((String)("Exceptions were thrown: " + this.exceptions), (this.exceptions.size() == 0 ? 1 : 0) != 0);
    }

    protected void configureServer() throws JMSException {
        if (this.server != null) {
            this.server.setTransportChannelListener((TransportChannelListener)this);
            this.server.start();
            System.out.println("Server has started");
        }
    }

    protected void configureReceiver() {
        this.receiver.setPacketListener((PacketListener)this);
        this.receiver.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException ex) {
                TransportChannelTestSupport.this.logMessage("Receiver got an exception:", ex);
            }
        });
        this.receiver.setClientID("receiver");
        try {
            this.receiver.start();
        }
        catch (JMSException e) {
            this.logMessage("Failure starting receiver: ", e);
        }
        System.out.println("Receiver has started");
    }

    protected void createSenderAndReceiver(String string) throws URISyntaxException, JMSException {
        URI uri = new URI(string);
        this.receiver = TransportChannelProvider.create((WireFormat)this.wireFormat, (URI)uri);
        if (this.receiver != null) {
            this.configureReceiver();
        }
        this.sender = TransportChannelProvider.create((WireFormat)this.wireFormat, (URI)uri);
    }

    protected void createSenderAndServer(String subject) throws URISyntaxException, JMSException {
        URI uri = new URI(subject);
        this.server = TransportServerChannelProvider.create((WireFormat)this.wireFormat, (URI)uri);
        this.configureServer();
        this.sender = TransportChannelProvider.create((WireFormat)this.wireFormat, (URI)uri);
    }

    protected void logMessage(String message, JMSException ex) {
        System.err.println(message);
        ex.printStackTrace();
        Exception t = ex.getLinkedException();
        if (t != null && t != ex) {
            System.out.println("Reason: " + t);
            t.printStackTrace();
        }
        this.exceptions.add(ex);
    }

    public void addClient(TransportChannel channel) {
        this.receiver = channel;
        this.closeReceiver = false;
        System.out.println("addClient() with receiver: " + this.receiver);
        TransportChannelTestSupport.assertTrue((String)"Should have received a receiver by now", (this.receiver != null ? 1 : 0) != 0);
        this.configureReceiver();
    }

    public void removeClient(TransportChannel channel) {
    }
}

