/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.TransportChannelProvider;
import org.activemq.transport.vm.VmTransportChannel;

public class TransportChannelProviderTest
extends TestCase {
    public void testVmChannelWithProperties() throws Exception {
        TransportChannel channel = this.createChannel("vm://localhost:0?asyncSend=true&sendCapacity=100&receiveCapacity=20");
        TransportChannelProviderTest.assertTrue((boolean)(channel instanceof VmTransportChannel));
        VmTransportChannel vmChannel = (VmTransportChannel)channel;
        TransportChannelProviderTest.assertEquals((String)"sendCapacity", (int)100, (int)vmChannel.getSendCapacity());
        TransportChannelProviderTest.assertEquals((String)"receiveCapacity", (int)20, (int)vmChannel.getReceiveCapacity());
        TransportChannelProviderTest.assertEquals((String)"asyncSend", (boolean)true, (boolean)vmChannel.isAsyncSend());
        vmChannel.start();
        TransportChannelProviderTest.assertTrue((String)"has send channel", (vmChannel.getSendChannel() != null ? 1 : 0) != 0);
        TransportChannelProviderTest.assertTrue((String)"has receive channel", (vmChannel.getReceiveChannel() != null ? 1 : 0) != 0);
        vmChannel.stop();
        vmChannel = (VmTransportChannel)this.createChannel("vm://localhost?receiveCapacity=20");
        vmChannel.start();
        TransportChannelProviderTest.assertTrue((String)"has no send channel", (vmChannel.getSendChannel() == null ? 1 : 0) != 0);
        TransportChannelProviderTest.assertTrue((String)"has receive channel", (vmChannel.getReceiveChannel() == null ? 1 : 0) != 0);
        vmChannel.stop();
    }

    protected TransportChannel createChannel(String uri) throws JMSException, URISyntaxException {
        return TransportChannelProvider.create((WireFormat)new DefaultWireFormat(), (URI)new URI(uri));
    }
}

