/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activecluster.ClusterException;
import org.activemq.transport.DiscoveryAgent;
import org.activemq.transport.DiscoveryEvent;
import org.activemq.transport.DiscoveryListener;

public abstract class DiscoveryAgentTestSupport
extends TestCase
implements DiscoveryListener {
    protected boolean waitForever = false;
    protected DiscoveryAgent agent;
    protected Map localDetails = new HashMap();
    protected String type = "_activemq_testcase.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiscovery() throws Exception {
        this.localDetails.put("cheese", "Cheddar");
        this.localDetails.put("location", "London");
        this.agent.addDiscoveryListener((DiscoveryListener)this);
        this.agent.start();
        this.agent.registerService(this.createName(), this.localDetails);
        if (this.waitForever) {
            DiscoveryAgentTestSupport discoveryAgentTestSupport = this;
            synchronized (discoveryAgentTestSupport) {
                ((Object)((Object)this)).wait();
            }
        }
        this.agent.stop();
    }

    protected String createName() {
        return this.getName() + "@" + System.currentTimeMillis();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.agent = this.createDiscoveryAgent();
        if (System.getProperty("waitForever") != null) {
            this.waitForever = true;
        }
    }

    protected abstract DiscoveryAgent createDiscoveryAgent() throws JMSException, ClusterException;

    public void addService(DiscoveryEvent event) {
        System.out.println("Added service: " + event + " with details: " + event.getServiceDetails() + " name: " + event.getServiceName());
    }

    public void removeService(DiscoveryEvent event) {
        System.out.println("Removed service: " + event);
    }
}

