/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.io.WireFormat;
import org.activemq.message.ActiveMQMapMessage;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQObjectMessage;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.Packet;

public abstract class WireFormatTestSupport
extends TestCase {
    protected WireFormat wireFormat;

    public void testMessage() throws Exception {
        ActiveMQMessage expected = this.createMessage();
        Packet actual = this.writeThenReadPacket(expected);
        this.assertMessage(expected, (ActiveMQMessage)actual);
    }

    public void testTextMessage() throws Exception {
        ActiveMQTextMessage expected = this.createTextMessage();
        Packet actual = this.writeThenReadPacket((ActiveMQMessage)expected);
        this.assertTextMessage(expected, (ActiveMQTextMessage)actual);
    }

    public void testObjectMessage() throws Exception {
        ActiveMQObjectMessage expected = this.createObjectMessage();
        Packet actual = this.writeThenReadPacket((ActiveMQMessage)expected);
        this.assertObjectMessage(expected, (ActiveMQObjectMessage)actual);
    }

    public void testMapMessage() throws Exception {
        ActiveMQMapMessage expected = this.createMapMessage();
        Packet actual = this.writeThenReadPacket((ActiveMQMessage)expected);
        this.assertMapMessage(expected, (ActiveMQMapMessage)actual);
    }

    protected void assertTextMessage(ActiveMQTextMessage expected, ActiveMQTextMessage actual) throws JMSException {
        this.assertMessage((ActiveMQMessage)expected, (ActiveMQMessage)actual);
        WireFormatTestSupport.assertEquals((String)"text", (String)expected.getText(), (String)actual.getText());
    }

    protected ActiveMQTextMessage createTextMessage() throws JMSException {
        ActiveMQTextMessage answer = new ActiveMQTextMessage();
        answer.setText("This is some text");
        this.configureMessage((ActiveMQMessage)answer);
        return answer;
    }

    protected void assertObjectMessage(ActiveMQObjectMessage expected, ActiveMQObjectMessage actual) throws JMSException {
        this.assertMessage((ActiveMQMessage)expected, (ActiveMQMessage)actual);
        WireFormatTestSupport.assertEquals((String)"object", (Object)expected.getObject(), (Object)actual.getObject());
    }

    protected ActiveMQObjectMessage createObjectMessage() throws JMSException {
        ActiveMQObjectMessage answer = new ActiveMQObjectMessage();
        answer.setObject((Serializable)((Object)"This is some text"));
        this.configureMessage((ActiveMQMessage)answer);
        return answer;
    }

    protected void assertMapMessage(ActiveMQMapMessage expected, ActiveMQMapMessage actual) throws JMSException {
        this.assertMessage((ActiveMQMessage)expected, (ActiveMQMessage)actual);
        WireFormatTestSupport.assertEquals((String)"propertyBool", (boolean)expected.getBooleanProperty("propertyBool"), (boolean)actual.getBooleanProperty("propertyBool"));
        WireFormatTestSupport.assertEquals((String)"propertyByte", (byte)expected.getByteProperty("propertyByte"), (byte)actual.getByteProperty("propertyByte"));
        this.assertEquals("propertyDouble", expected.getDoubleProperty("propertyDouble"), actual.getDoubleProperty("propertyDouble"));
        this.assertEquals("propertyFloat", expected.getFloatProperty("propertyFloat"), actual.getFloatProperty("propertyFloat"));
        WireFormatTestSupport.assertEquals((String)"propertyInt", (int)expected.getIntProperty("propertyInt"), (int)actual.getIntProperty("propertyInt"));
        WireFormatTestSupport.assertEquals((String)"propertyLong", (long)expected.getLongProperty("propertyLong"), (long)actual.getLongProperty("propertyLong"));
        WireFormatTestSupport.assertEquals((String)"propertyShort", (short)expected.getShortProperty("propertyShort"), (short)actual.getShortProperty("propertyShort"));
        WireFormatTestSupport.assertEquals((String)"propertyString", (String)expected.getStringProperty("propertyString"), (String)actual.getStringProperty("propertyString"));
    }

    protected ActiveMQMapMessage createMapMessage() throws JMSException {
        ActiveMQMapMessage answer = new ActiveMQMapMessage();
        answer.setBooleanProperty("propertyBool", true);
        answer.setByteProperty("propertyByte", (byte)44);
        answer.setDoubleProperty("propertyDouble", 123.456);
        answer.setFloatProperty("propertyFloat", 22.223455f);
        answer.setIntProperty("propertyInt", 1234567);
        answer.setLongProperty("propertyLong", 1234567890L);
        answer.setShortProperty("propertyShort", (short)1234);
        answer.setStringProperty("propertyString", "This is some text");
        this.configureMessage((ActiveMQMessage)answer);
        return answer;
    }

    protected void assertMessage(ActiveMQMessage expected, ActiveMQMessage actual) throws JMSException {
        WireFormatTestSupport.assertEquals((String)"getBooleanProperty", (boolean)expected.getBooleanProperty("fooBool"), (boolean)actual.getBooleanProperty("fooBool"));
        WireFormatTestSupport.assertEquals((String)"getByteProperty", (byte)expected.getByteProperty("fooByte"), (byte)actual.getByteProperty("fooByte"));
        WireFormatTestSupport.assertEquals((String)"getEntryBrokerName", (String)expected.getEntryBrokerName(), (String)actual.getEntryBrokerName());
        WireFormatTestSupport.assertEquals((String)"getJMSClientID", (String)expected.getJMSClientID(), (String)actual.getJMSClientID());
        WireFormatTestSupport.assertEquals((String)"getJMSCorrelationID", (String)expected.getJMSCorrelationID(), (String)actual.getJMSCorrelationID());
        WireFormatTestSupport.assertEquals((String)"getJMSDeliveryMode", (int)expected.getJMSDeliveryMode(), (int)actual.getJMSDeliveryMode());
        WireFormatTestSupport.assertEquals((String)"getJMSDestination", (Object)expected.getJMSDestination(), (Object)actual.getJMSDestination());
        WireFormatTestSupport.assertEquals((String)"getJMSExpiration", (long)expected.getJMSExpiration(), (long)actual.getJMSExpiration());
        WireFormatTestSupport.assertEquals((String)"getJMSMessageID", (String)expected.getJMSMessageID(), (String)actual.getJMSMessageID());
        WireFormatTestSupport.assertEquals((String)"getJMSPriority", (int)expected.getJMSPriority(), (int)actual.getJMSPriority());
        WireFormatTestSupport.assertEquals((String)"getJMSReplyTo", (Object)expected.getJMSReplyTo(), (Object)actual.getJMSReplyTo());
        WireFormatTestSupport.assertEquals((String)"getJMSType", (String)expected.getJMSType(), (String)actual.getJMSType());
        WireFormatTestSupport.assertEquals((String)"getStringProperty", (String)expected.getStringProperty("fooString"), (String)actual.getStringProperty("fooString"));
        WireFormatTestSupport.assertEquals((String)"getTransactionId", (Object)expected.getTransactionId(), (Object)actual.getTransactionId());
    }

    protected ActiveMQMessage createMessage() throws JMSException {
        ActiveMQMessage answer = new ActiveMQMessage();
        this.configureMessage(answer);
        return answer;
    }

    protected void configureMessage(ActiveMQMessage answer) throws JMSException {
        answer.setBooleanProperty("fooBool", true);
        answer.setByteProperty("fooByte", (byte)12);
        answer.setConsumerIdentifer("consumerId");
        answer.setEntryBrokerName("entryBroker");
        answer.setJMSClientID("myClientID");
        answer.setJMSCorrelationID("myCorrelationID");
        answer.setJMSDeliveryMode(2);
        answer.setJMSDestination((Destination)new ActiveMQTopic("FOO.BAR"));
        answer.setJMSExpiration(1234L);
        answer.setJMSMessageID("message:123");
        answer.setJMSPriority(2);
        answer.setJMSReplyTo((Destination)new ActiveMQQueue("BAR.REPLY"));
        answer.setJMSType("Cheddar");
        answer.setStringProperty("fooString", "Whatnot");
        answer.setTransactionId((Object)"myTxnID");
        answer.setExternalMessageId(true);
    }

    protected void setUp() throws Exception {
        this.wireFormat = this.createWireFormat();
    }

    protected abstract WireFormat createWireFormat();

    protected void assertEquals(String message, double expected, double actual) {
        WireFormatTestSupport.assertEquals((String)message, (Object)new Double(expected), (Object)new Double(actual));
    }

    protected Packet writeThenReadPacket(ActiveMQMessage expected) throws IOException, JMSException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.wireFormat.writePacket((Packet)expected, (DataOutput)new DataOutputStream(buffer));
        Packet actual = this.wireFormat.readPacket((DataInput)this.createDataIn(buffer));
        return actual;
    }

    protected DataInputStream createDataIn(ByteArrayOutputStream buffer) {
        return new DataInputStream(new ByteArrayInputStream(buffer.toByteArray()));
    }
}

