/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import javax.jms.JMSException;
import org.activemq.DuplicateDurableSubscriptionException;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.TopicMessageContainer;
import org.activemq.test.MessageStoreTestSupport;

public abstract class TopicMessageStoreTestSupport
extends MessageStoreTestSupport {
    public void atestDuplicateSubscription() throws Exception {
        ConsumerInfo info = this.createConsumerInfo();
        info.setSelector("priority > 3");
        try {
            this.messageContainerManager.addMessageConsumer(this.client, info);
            info = this.createConsumerInfo();
            this.messageContainerManager.addMessageConsumer(this.client, info);
            TopicMessageStoreTestSupport.fail((String)("Should have failed by now adding duplicate subscriptions to container manager: " + this.messageContainerManager));
        }
        catch (DuplicateDurableSubscriptionException e) {
            System.out.println("Worked. Generated: " + (Object)((Object)e));
        }
    }

    protected void acknowledgeMessage(int i) throws JMSException {
        this.getTopicMessageContainer().setLastAcknowledgedMessageID(this.subscription, this.getMessage(i).getJMSMessageIdentity());
    }

    protected TopicMessageContainer getTopicMessageContainer() {
        return (TopicMessageContainer)this.container;
    }

    protected ActiveMQDestination createDestination() {
        return new ActiveMQTopic(this.getSubject());
    }

    protected void recover() throws JMSException {
        this.getTopicMessageContainer().recoverSubscription(this.subscription);
    }

    protected ActiveMQMessage[] getMessagesToDispatch() throws JMSException {
        this.recover();
        return this.subscription.getMessagesToDispatch();
    }
}

