/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import EDU.oswego.cs.dl.util.concurrent.CountDown;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.activemq.test.JmsTopicSendReceiveTest;

public class SendReceiveTest
extends JmsTopicSendReceiveTest {
    private CountDown countDown;

    public void testSendReceive() throws Exception {
        this.sendSomeMessagesAndCheckTheyAreAllReceived(1);
        this.sendSomeMessagesAndCheckTheyAreAllReceived(2);
        this.sendSomeMessagesAndCheckTheyAreAllReceived(3);
        this.sendSomeMessagesAndCheckTheyAreAllReceived(4);
    }

    public void testSendReceiveReusingTheMessageInstance() throws Exception {
        this.sendSomeMessagesReusingTheSameMessageAndCheckTheyAreAllReceived(1);
        this.sendSomeMessagesReusingTheSameMessageAndCheckTheyAreAllReceived(2);
        this.sendSomeMessagesReusingTheSameMessageAndCheckTheyAreAllReceived(3);
        this.sendSomeMessagesReusingTheSameMessageAndCheckTheyAreAllReceived(4);
    }

    public void onMessage(Message message) {
        if (this.countDown != null) {
            this.countDown.release();
        } else {
            System.out.println("Warning: no countDown available!");
        }
    }

    protected void sendSomeMessagesAndCheckTheyAreAllReceived(int numberOfMessages) throws JMSException, InterruptedException {
        this.countDown = new CountDown(numberOfMessages);
        for (int i = 0; i < numberOfMessages; ++i) {
            this.producer.send(this.producerDestination, (Message)this.session.createTextMessage("hi"));
        }
        this.countDown.attempt(5000L);
        SendReceiveTest.assertEquals((String)("Undelivered messages for count: " + numberOfMessages), (int)0, (int)this.countDown.currentCount());
    }

    protected void sendSomeMessagesReusingTheSameMessageAndCheckTheyAreAllReceived(int numberOfMessages) throws JMSException, InterruptedException {
        this.countDown = new CountDown(numberOfMessages);
        TextMessage message = this.session.createTextMessage();
        for (int i = 0; i < numberOfMessages; ++i) {
            message.setText("This is message: " + i);
            this.producer.send(this.producerDestination, (Message)message);
        }
        this.countDown.attempt(5000L);
        SendReceiveTest.assertEquals((String)("Undelivered messages for count: " + numberOfMessages), (int)0, (int)this.countDown.currentCount());
    }
}

