/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import java.util.Date;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import junit.framework.TestCase;

public class RollbackTest
extends TestCase
implements MessageListener {
    public final String JMS_FACTORY = "QueueConnectionFactory";
    public final String QUEUE = "DNQueue";
    Context ctx;
    QueueConnectionFactory qfact;
    QueueConnection qcon;
    QueueSession sess;
    Queue q;
    QueueReceiver qrec;
    private int commitCount;
    private int rollbackCount;
    private JMSException exception;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRun() throws Exception {
        this.sendMessages();
        this.qcon.start();
        for (int i = 0; i < 10; ++i) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(2000L);
            }
            if (this.rollbackCount >= 4) break;
        }
        RollbackTest.assertTrue((String)("Should have rolled back at least twice, but was: " + this.rollbackCount), (this.rollbackCount >= 4 ? 1 : 0) != 0);
        RollbackTest.assertEquals((String)"Should have commit twice", (int)2, (int)this.commitCount);
        RollbackTest.assertEquals((String)"Should not have caught an exception", null, (Object)((Object)this.exception));
        System.out.println("DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        block6: {
            TextMessage tm = (TextMessage)msg;
            try {
                String text = tm.getText();
                System.out.println("Received MSG : " + text);
                if (text.startsWith("5") || text.startsWith("10")) {
                    System.out.println("Committing!");
                    this.sess.commit();
                    ++this.commitCount;
                    break block6;
                }
                if (!text.startsWith("9")) break block6;
                System.out.println("Rolling back!");
                this.sess.rollback();
                ++this.rollbackCount;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
            }
            catch (JMSException e) {
                System.out.println("Exception: " + (Object)((Object)e));
                e.printStackTrace();
                this.exception = e;
            }
        }
    }

    protected void setUp() throws Exception {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "org.activemq.jndi.ActiveMQInitialContextFactory");
        env.put("java.naming.provider.url", "vm://localhost");
        env.put("queue.DNQueue", ((Object)((Object)this)).getClass().getName());
        this.ctx = new InitialContext(env);
        this.qfact = (QueueConnectionFactory)this.ctx.lookup("QueueConnectionFactory");
        this.qcon = this.qfact.createQueueConnection();
        this.sess = this.qcon.createQueueSession(true, -1);
        this.q = (Queue)this.ctx.lookup("DNQueue");
        RollbackTest.assertNotNull((Object)this.q);
        this.qrec = this.sess.createReceiver(this.q);
        this.qrec.setMessageListener((MessageListener)this);
    }

    protected void tearDown() throws Exception {
        this.sess.close();
        this.qcon.close();
    }

    public void sendMessages() throws Exception {
        QueueSession sess = this.qcon.createQueueSession(false, 1);
        QueueSender qsend = sess.createSender(this.q);
        for (int i = 1; i <= 10; ++i) {
            String data = "" + i + " " + new Date();
            TextMessage tm = sess.createTextMessage();
            tm.setText(data);
            qsend.send((Message)tm);
            System.out.println("Message Sent: " + data);
        }
        qsend.close();
        sess.close();
    }
}

