/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import java.util.ArrayList;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.MessageAck;
import org.activemq.service.MessageIdentity;
import org.activemq.service.QueueMessageContainer;
import org.activemq.test.MessageStoreTestSupport;

public abstract class QueueMessageStoreTestSupport
extends MessageStoreTestSupport {
    protected void acknowledgeMessage(int i) throws JMSException {
        MessageIdentity identity = this.getMessage(i).getJMSMessageIdentity();
        this.getQueueMessageContainer().delete(identity, this.createMessageAck(identity, this.getMessage(i).getJMSDestination()));
    }

    protected QueueMessageContainer getQueueMessageContainer() {
        return (QueueMessageContainer)this.container;
    }

    protected ActiveMQDestination createDestination() {
        return new ActiveMQQueue(this.getSubject());
    }

    protected void recover() throws JMSException {
    }

    protected MessageAck createMessageAck(MessageIdentity messageIdentity, Destination destination) {
        MessageAck answer = new MessageAck();
        answer.setConsumerId("James");
        answer.setMessageID(messageIdentity.getMessageID());
        answer.setMessageRead(true);
        answer.setDestination(this.destination);
        return answer;
    }

    protected ActiveMQMessage[] getMessagesToDispatch() throws JMSException {
        ActiveMQMessage message;
        ArrayList<ActiveMQMessage> list = new ArrayList<ActiveMQMessage>();
        while ((message = this.getQueueMessageContainer().poll()) != null) {
            list.add(message);
        }
        ActiveMQMessage[] answer = new ActiveMQMessage[list.size()];
        list.toArray(answer);
        return answer;
    }
}

