/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.activemq.broker.BrokerClient;
import org.activemq.broker.impl.BrokerClientImpl;
import org.activemq.filter.DestinationFilter;
import org.activemq.filter.Filter;
import org.activemq.filter.FilterFactory;
import org.activemq.filter.FilterFactoryImpl;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.DeadLetterPolicy;
import org.activemq.service.Dispatcher;
import org.activemq.service.MessageContainer;
import org.activemq.service.MessageContainerManager;
import org.activemq.service.MessageIdentity;
import org.activemq.service.RedeliveryPolicy;
import org.activemq.service.Subscription;
import org.activemq.service.SubscriptionContainer;
import org.activemq.service.impl.DispatcherImpl;
import org.activemq.service.impl.DurableQueueMessageContainer;
import org.activemq.service.impl.DurableQueueMessageContainerManager;
import org.activemq.service.impl.DurableTopicMessageContainer;
import org.activemq.service.impl.DurableTopicMessageContainerManager;
import org.activemq.service.impl.DurableTopicSubscription;
import org.activemq.service.impl.DurableTopicSubscriptionContainerImpl;
import org.activemq.store.PersistenceAdapter;
import org.activemq.util.Callback;
import org.activemq.util.IdGenerator;
import org.activemq.util.TransactionTemplate;

public abstract class MessageStoreTestSupport
extends TestCase {
    protected PersistenceAdapter persistenceAapter;
    protected MessageContainer container;
    protected Subscription subscription;
    protected int publishMessageCount = 10;
    protected int ackCount = 5;
    protected ActiveMQMessage[] messages;
    protected ActiveMQDestination destination;
    protected IdGenerator idGenerator = new IdGenerator();
    protected MessageContainerManager messageContainerManager;
    protected BrokerClient client = new BrokerClientImpl();
    protected TransactionTemplate template;

    public void testRecovery() throws Exception {
        int i;
        System.out.println("Publishing: " + this.publishMessageCount + " messages");
        for (i = 0; i < this.publishMessageCount; ++i) {
            this.doAddMessage(i);
        }
        this.dumpMessageIdentities("After add");
        this.assertDeliveryList(0, this.publishMessageCount);
        System.out.println("Acknowledging the first: " + this.ackCount + " messages");
        for (i = 0; i < this.ackCount; ++i) {
            this.doAcknowledgeMessage(i);
        }
        this.assertDeliveryList(0, 0);
        this.dumpMessageIdentities("After ack of first part");
        this.closeAndReopenContainer();
        this.assertDeliveryList(this.ackCount, this.publishMessageCount);
        this.dumpMessageIdentities("About to perform final ack");
        for (i = this.ackCount; i < this.publishMessageCount; ++i) {
            this.doAcknowledgeMessage(i);
        }
    }

    public void testRecoveryOfNewConsumerWhichHasYetToAck() throws Exception {
        for (int i = 0; i < this.publishMessageCount; ++i) {
            this.doAddMessage(i);
        }
        this.assertDeliveryList(0, this.publishMessageCount);
        this.assertDeliveryList(0, 0);
        this.closeAndReopenContainer();
        this.assertDeliveryList(0, this.publishMessageCount);
    }

    protected abstract void acknowledgeMessage(int var1) throws JMSException;

    protected abstract PersistenceAdapter createPersistenceAdapter() throws IOException, Exception;

    protected abstract ActiveMQDestination createDestination();

    protected abstract ActiveMQMessage[] getMessagesToDispatch() throws JMSException;

    protected void doAcknowledgeMessage(final int i) throws JMSException {
        this.template.run(new Callback(){

            public void execute() throws Throwable {
                MessageStoreTestSupport.this.acknowledgeMessage(i);
            }
        });
    }

    protected void doAddMessage(int i) throws JMSException {
        final ActiveMQMessage message = this.getMessage(i);
        this.template.run(new Callback(){

            public void execute() throws Throwable {
                MessageStoreTestSupport.this.container.addMessage(message);
            }
        });
    }

    protected void dumpMessageIdentities(String text) throws JMSException {
        System.out.println("#### Dumping identities at: " + text);
        for (int i = 0; i < this.publishMessageCount; ++i) {
            ActiveMQMessage message = this.getMessage(i);
            MessageIdentity identity = message.getJMSMessageIdentity();
            Object sequenceNo = identity.getSequenceNumber();
            String sequenceText = null;
            if (sequenceNo != null) {
                sequenceText = this.toStringFromSequenceNumber(sequenceNo);
            }
            System.out.println("item: " + i + " is: " + sequenceText);
        }
        System.out.println();
    }

    protected String toStringFromSequenceNumber(Object sequenceNo) {
        return sequenceNo.toString();
    }

    protected String asText(byte[] data) {
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(Byte.toString(data[i]));
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    protected MessageContainer createTopicMessageContainer() throws JMSException {
        if (this.destination.isTopic()) {
            return new DurableTopicMessageContainer(null, this.persistenceAapter.createTopicMessageStore(this.destination.toString()), this.destination.toString());
        }
        return new DurableQueueMessageContainer(this.persistenceAapter, this.persistenceAapter.createQueueMessageStore(this.destination.toString()), this.destination.toString());
    }

    protected Subscription createSubscription() throws JMSException {
        DestinationFilter filter = DestinationFilter.parseFilter((Destination)this.destination);
        ConsumerInfo consumerInfo = this.createConsumerInfo();
        this.messageContainerManager.addMessageConsumer(this.client, consumerInfo);
        return new DurableTopicSubscription((Dispatcher)new DispatcherImpl(), this.client, consumerInfo, (Filter)filter, new RedeliveryPolicy(), new DeadLetterPolicy());
    }

    protected ConsumerInfo createConsumerInfo() {
        ConsumerInfo answer = new ConsumerInfo();
        answer.setClientId(this.getClientID());
        answer.setConsumerId(this.idGenerator.generateId());
        answer.setConsumerName(this.getConsumerName());
        answer.setDestination(this.destination);
        answer.setPrefetchNumber(100);
        answer.setSessionId((short)123);
        answer.setStarted(true);
        return answer;
    }

    protected String getConsumerName() {
        return this.getName();
    }

    protected String getClientID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.messages = new ActiveMQMessage[this.publishMessageCount];
        this.destination = this.createDestination();
        this.persistenceAapter = this.createPersistenceAdapter();
        this.persistenceAapter.start();
        this.template = new TransactionTemplate(this.persistenceAapter);
        this.messageContainerManager = this.createMessageContainerManager();
        this.container = this.messageContainerManager.getContainer(this.destination.getPhysicalName());
        MessageStoreTestSupport.assertTrue((String)"Should have created a container", (this.container != null ? 1 : 0) != 0);
        this.subscription = this.createSubscription();
    }

    protected void tearDown() throws Exception {
        this.messageContainerManager.destroyMessageContainer(this.destination);
        this.messageContainerManager.stop();
        this.persistenceAapter.stop();
        super.tearDown();
    }

    protected MessageContainerManager createMessageContainerManager() {
        if (this.destination.isTopic()) {
            return new DurableTopicMessageContainerManager(this.persistenceAapter, (SubscriptionContainer)new DurableTopicSubscriptionContainerImpl(new RedeliveryPolicy(), new DeadLetterPolicy()), (FilterFactory)new FilterFactoryImpl(), (Dispatcher)new DispatcherImpl());
        }
        return new DurableQueueMessageContainerManager(this.persistenceAapter, (SubscriptionContainer)new DurableTopicSubscriptionContainerImpl(new RedeliveryPolicy(), new DeadLetterPolicy()), (FilterFactory)new FilterFactoryImpl(), (Dispatcher)new DispatcherImpl());
    }

    protected void assertDeliveryList(final int startIndex, final int lastIndex) throws JMSException {
        this.template.run(new Callback(){

            public void execute() throws Throwable {
                ActiveMQMessage[] messagesToDispatch = MessageStoreTestSupport.this.getMessagesToDispatch();
                int count = lastIndex - startIndex;
                Assert.assertTrue((String)("Not enough messages available to dispatch. Expected: " + count + " messages but was: " + messagesToDispatch.length), (messagesToDispatch.length >= count ? 1 : 0) != 0);
                for (int i = 0; i < count; ++i) {
                    ActiveMQMessage expected = MessageStoreTestSupport.this.getMessage(i + startIndex);
                    ActiveMQMessage actual = messagesToDispatch[i];
                    MessageStoreTestSupport.this.assertMessagesEqual("Dispatched message at index: " + i, expected, actual);
                }
            }
        });
    }

    protected void assertMessagesEqual(String description, ActiveMQMessage expected, ActiveMQMessage actual) throws JMSException {
        MessageStoreTestSupport.assertEquals((String)("MessageText compare. " + description), (String)((TextMessage)expected).getText(), (String)((TextMessage)actual).getText());
        MessageStoreTestSupport.assertEquals((String)("MessageID compare. " + description + " expected: " + expected + " actual: " + actual), (String)expected.getJMSMessageID(), (String)actual.getJMSMessageID());
        MessageStoreTestSupport.assertEquals((String)description, (Object)expected, (Object)actual);
    }

    protected ActiveMQMessage getMessage(int i) throws JMSException {
        if (this.messages[i] == null) {
            this.messages[i] = this.createMessage(i);
        }
        return this.messages[i];
    }

    protected ActiveMQMessage createMessage(int i) throws JMSException {
        ActiveMQTextMessage answer = new ActiveMQTextMessage();
        answer.setJMSMessageID(this.idGenerator.generateId());
        answer.setJMSClientID(this.getClientID());
        answer.setJMSDestination((Destination)this.destination);
        answer.setText("message index: " + i);
        return answer;
    }

    protected void closeAndReopenContainer() throws Exception {
        this.subscription.clear();
        this.messageContainerManager.stop();
        this.persistenceAapter.stop();
        this.persistenceAapter = this.createPersistenceAdapter();
        this.persistenceAapter.start();
        this.template = new TransactionTemplate(this.persistenceAapter);
        this.messageContainerManager = this.createMessageContainerManager();
        this.container = this.messageContainerManager.getContainer(this.destination.getPhysicalName());
        this.subscription = this.createSubscription();
        this.template.run(new Callback(){

            public void execute() throws Throwable {
                MessageStoreTestSupport.this.recover();
            }
        });
    }

    protected void recover() throws JMSException {
    }

    protected String getSubject() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }
}

