/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.MessageAck;
import org.activemq.service.MessageContainer;
import org.activemq.service.MessageIdentity;
import org.activemq.service.impl.DurableQueueMessageContainer;
import org.activemq.service.impl.DurableTopicMessageContainer;
import org.activemq.store.PersistenceAdapter;
import org.activemq.test.TimedTransactionTemplate;
import org.activemq.util.Callback;
import org.activemq.util.IdGenerator;
import org.activemq.util.TransactionTemplate;

public abstract class MessageContainerTestSupport
extends TestCase {
    protected MessageContainer container;
    protected int messageCount = 50;
    protected IdGenerator idGenerator = new IdGenerator();
    protected String[] messageIds;
    protected MessageIdentity[] messageIdenties;
    private String[] messageTexts;
    protected PersistenceAdapter persistenceAdapter;
    protected boolean topic = false;
    private String destinationName;
    protected TransactionTemplate transactionTemplate;

    public void testWriteLoop() throws Exception {
        this.transactionTemplate.run(new Callback(){

            public void execute() throws Throwable {
                MessageContainerTestSupport.this.writeMessage(0);
                MessageIdentity messageIdentity = new MessageIdentity(MessageContainerTestSupport.this.messageIds[0]);
                MessageContainerTestSupport.this.container.delete(messageIdentity, MessageContainerTestSupport.this.createMessageAck(messageIdentity));
            }
        });
        System.out.println("About to write: " + this.messageCount + " messages to the container: " + this.container);
        this.transactionTemplate.run(new Callback(){

            public void execute() throws Throwable {
                for (int i = 0; i < MessageContainerTestSupport.this.messageCount; ++i) {
                    MessageContainerTestSupport.this.writeMessage(i + 1);
                }
            }
        });
        System.out.println("About to read: " + this.messageCount + " messages");
        this.transactionTemplate.run(new Callback(){

            public void execute() throws Throwable {
                for (int i = 0; i < MessageContainerTestSupport.this.messageCount; ++i) {
                    MessageContainerTestSupport.this.readMessage(i + 1);
                }
            }
        });
        System.out.println("About to delete: " + this.messageCount + " messages");
        this.transactionTemplate.run(new Callback(){

            public void execute() throws Throwable {
                for (int i = 0; i < MessageContainerTestSupport.this.messageCount; ++i) {
                    MessageContainerTestSupport.this.deleteMessage(i + 1);
                }
            }
        });
        if (!this.topic) {
            System.out.println("About to check that all the messages are consumed");
            this.transactionTemplate.run(new Callback(){

                public void execute() throws Throwable {
                    for (int i = 0; i < MessageContainerTestSupport.this.messageCount; ++i) {
                        MessageContainerTestSupport.this.assertNoMessage(i + 1);
                    }
                }
            });
        }
    }

    public String getDestinationName() {
        if (this.destinationName == null) {
            this.destinationName = ((Object)((Object)this)).getClass().getName() + "." + this.getName();
        }
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    protected long startUnitOfWork() throws Exception {
        return System.currentTimeMillis();
    }

    protected long endUnitOfWork() throws Exception {
        return System.currentTimeMillis();
    }

    protected void setUp() throws Exception {
        super.setUp();
        String value = System.getProperty("messageCount");
        if (value != null) {
            this.messageCount = Integer.parseInt(value);
        }
        this.messageIds = new String[this.messageCount + 1];
        this.messageTexts = new String[this.messageCount + 1];
        this.messageIdenties = new MessageIdentity[this.messageCount + 1];
        this.persistenceAdapter = this.createPersistenceAdapter();
        this.persistenceAdapter.start();
        this.transactionTemplate = new TimedTransactionTemplate(this.persistenceAdapter, this.messageCount);
        this.container = this.createContainer();
        MessageContainerTestSupport.assertTrue(("Should have created a container: " + this.container != null ? 1 : 0) != 0);
        this.container.start();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.container != null) {
            this.container.stop();
        }
        this.persistenceAdapter.stop();
    }

    protected MessageContainer createContainer() throws JMSException {
        if (this.topic) {
            return new DurableTopicMessageContainer(null, this.persistenceAdapter.createTopicMessageStore(this.getDestinationName()), this.getDestinationName());
        }
        return new DurableQueueMessageContainer(this.persistenceAdapter, this.persistenceAdapter.createQueueMessageStore(this.getDestinationName()), this.getDestinationName());
    }

    protected PersistenceAdapter createPersistenceAdapter() throws Exception {
        MessageContainerTestSupport.assertTrue((String)"Must overload this method to create a PersistenceAdapater", (boolean)false);
        return null;
    }

    protected void writeMessage(int i) throws JMSException {
        String id;
        ActiveMQMessage message = this.createMessage(i);
        this.messageIds[i] = id = this.idGenerator.generateId();
        message.setJMSMessageID(id);
        this.container.addMessage(message);
        this.messageIdenties[i] = message.getJMSMessageIdentity();
    }

    protected void readMessage(int i) throws JMSException {
        ActiveMQTextMessage message = (ActiveMQTextMessage)this.container.getMessage(this.messageIdenties[i]);
        MessageContainerTestSupport.assertTrue((String)"Message should not be null", (message != null ? 1 : 0) != 0);
        String text = message.getText();
        MessageContainerTestSupport.assertEquals((String)"Message text should be equal", (String)this.messageTexts[i], (String)text);
        MessageContainerTestSupport.assertEquals((String)this.messageIds[i], (String)message.getJMSMessageID());
    }

    protected MessageAck createMessageAck(MessageIdentity messageIdentity) {
        MessageAck answer = new MessageAck();
        answer.setConsumerId(this.idGenerator.generateId());
        answer.setMessageID(messageIdentity.getMessageID());
        answer.setMessageRead(true);
        return answer;
    }

    protected void deleteMessage(int i) throws JMSException {
        this.container.delete(this.messageIdenties[i], this.createMessageAck(this.messageIdenties[i]));
    }

    protected void assertNoMessage(int i) throws JMSException {
        ActiveMQMessage message = this.container.getMessage(this.messageIdenties[i]);
        MessageContainerTestSupport.assertTrue((String)"Message should be null", (message == null ? 1 : 0) != 0);
    }

    protected ActiveMQMessage createMessage(int i) throws JMSException {
        String text;
        ActiveMQTextMessage answer = new ActiveMQTextMessage();
        this.messageTexts[i] = text = "Message: " + i;
        answer.setText(text);
        return answer;
    }
}

