/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.TestSupport;
import org.activemq.test.JmsResourceProvider;
import org.activemq.test.XidStub;
import org.activemq.util.IndentPrinter;

public abstract class JmsXATransactionTestSupport
extends TestSupport {
    static boolean firstRun;
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    private JmsResourceProvider provider;
    private MessageProducer producer2;
    private Destination destination;

    public JmsXATransactionTestSupport() {
    }

    public JmsXATransactionTestSupport(String name) {
        super(name);
    }

    public void testSendOutsideXATransaction() throws Exception {
        try {
            this.producer.send((Message)this.session.createTextMessage("First Message"));
            JmsXATransactionTestSupport.fail((String)"Using an XA session outside of a transaction should throw an exception.");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testSendRollback() throws Exception {
        XAResource resource = ((XASession)this.session).getXAResource();
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        XidStub xid1 = new XidStub(new byte[]{1, 2, 3, 4, 5});
        resource.start(xid1, 0);
        this.producer.send(outbound[0]);
        resource.end(xid1, 0x4000000);
        resource.commit(xid1, true);
        XidStub xid2 = new XidStub(new byte[]{2, 2, 3, 4, 5});
        resource.start(xid2, 0);
        this.producer.send((Message)this.session.createTextMessage("I'm going to get rolled back."));
        resource.end(xid2, 0x4000000);
        resource.rollback(xid2);
        XidStub xid3 = new XidStub(new byte[]{3, 2, 3, 4, 5});
        resource.start(xid3, 0);
        this.producer.send(outbound[1]);
        resource.end(xid3, 0x4000000);
        if (resource.prepare(xid3) == 0) {
            resource.commit(xid3, false);
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        XidStub xid4 = new XidStub(new byte[]{4, 2, 3, 4, 5});
        resource.start(xid4, 0);
        messages.add(this.consumer.receive(1000L));
        messages.add(this.consumer.receive(1000L));
        resource.end(xid4, 0x4000000);
        resource.commit(xid4, true);
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work.", outbound, inbound);
    }

    public void testSendPrepareRecoverRollback() throws Exception {
        XAResource resource = ((XASession)this.session).getXAResource();
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        XidStub xid2 = new XidStub(new byte[]{1, 2, 3, 4, 6});
        resource.start(xid2, 0);
        this.producer.send((Message)this.session.createTextMessage("I'm going to get rolled back."));
        resource.end(xid2, 0x4000000);
        JmsXATransactionTestSupport.assertEquals((int)0, (int)resource.prepare(xid2));
        XidStub xid3 = new XidStub(new byte[]{2, 2, 3, 4, 6});
        resource.start(xid3, 0);
        this.producer.send(outbound[1]);
        resource.end(xid3, 0x4000000);
        JmsXATransactionTestSupport.assertEquals((int)0, (int)resource.prepare(xid3));
        this.restart();
        resource = ((XASession)this.session).getXAResource();
        resource.commit(xid3, false);
        resource.rollback(xid2);
    }

    public void testXAWith2Sessions() throws Exception {
        Session session2 = this.provider.createSession(this.connection);
        System.out.println("Created session: " + session2);
        this.producer2 = this.provider.createProducer(session2, this.destination);
        System.out.println("Created producer: " + this.producer2);
        XAResource resource1 = ((XASession)this.session).getXAResource();
        XAResource resource2 = ((XASession)session2).getXAResource();
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message!"), this.session.createTextMessage("Second Message!")};
        XidStub xid1 = new XidStub(new byte[]{1, 2, 3, 4, 5});
        resource1.start(xid1, 0);
        resource2.start(xid1, 0);
        this.producer.send(outbound[0]);
        this.producer2.send(outbound[1]);
        resource1.end(xid1, 0x4000000);
        resource2.end(xid1, 0x4000000);
        resource1.commit(xid1, true);
        ArrayList<Message> messages = new ArrayList<Message>();
        XidStub xid4 = new XidStub(new byte[]{4, 2, 3, 4, 5});
        resource1.start(xid4, 0);
        messages.add(this.consumer.receive(1000L));
        messages.add(this.consumer.receive(1000L));
        resource1.end(xid4, 0x4000000);
        resource1.commit(xid4, true);
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Failed.", outbound, inbound);
    }

    protected abstract JmsResourceProvider getJmsResourceProvider();

    protected void setUp() throws Exception {
        if (!firstRun) {
            TestSupport.removeMessageStore();
            firstRun = true;
        }
        super.setUp();
        this.openConnection();
    }

    protected void restart() throws JMSException {
        try {
            this.closeConnection();
            this.openConnection();
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void openConnection() throws JMSException {
        this.provider = this.getJmsResourceProvider();
        this.connectionFactory = this.provider.createConnectionFactory();
        this.connection = this.provider.createConnection(this.connectionFactory);
        System.out.println("Created connection: " + this.connection);
        this.session = this.provider.createSession(this.connection);
        System.out.println("Created session: " + this.session);
        this.destination = this.provider.createDestination(this.session, "QUEUE." + this.getName() + "." + System.currentTimeMillis());
        System.out.println("Created destination: " + this.destination + " of type: " + this.destination.getClass());
        this.producer = this.provider.createProducer(this.session, this.destination);
        System.out.println("Created producer: " + this.producer);
        this.consumer = this.provider.createConsumer(this.session, this.destination);
        System.out.println("Created consumer: " + this.consumer);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        System.out.println("Test Done.  Stats");
        ((ActiveMQConnectionFactory)this.connectionFactory).getFactoryStats().dump(new IndentPrinter());
        this.closeConnection();
    }

    private void closeConnection() throws JMSException {
        System.out.println("Closing down connection");
        this.connection.stop();
        this.connection.close();
        System.out.println("Connection closed.");
    }
}

