/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import javax.jms.Connection;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.test.JmsSendReceiveTestSupport;

public class JmsTopicSendReceiveWithTwoConnectionsTest
extends JmsSendReceiveTestSupport {
    protected Connection sendConnection;
    protected Connection receiveConnection;
    protected Session receiveSession;

    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.sendConnection = this.createSendConnection();
        this.sendConnection.start();
        this.receiveConnection = this.createReceiveConnection();
        this.receiveConnection.start();
        System.out.println("Created sendConnection: " + this.sendConnection);
        System.out.println("Created receiveConnection: " + this.receiveConnection);
        this.session = this.sendConnection.createSession(false, 1);
        this.receiveSession = this.receiveConnection.createSession(false, 1);
        System.out.println("Created sendSession: " + this.session);
        System.out.println("Created receiveSession: " + this.receiveSession);
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        System.out.println("Created producer: " + this.producer + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT"));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        System.out.println("Created  consumer destination: " + this.consumerDestination + " of type: " + this.consumerDestination.getClass());
        System.out.println("Created  producer destination: " + this.producerDestination + " of type: " + this.producerDestination.getClass());
        this.consumer = this.receiveSession.createConsumer(this.consumerDestination);
        this.consumer.setMessageListener((MessageListener)this);
        Thread.sleep(2000L);
        System.out.println("Started connections");
    }

    protected Connection createReceiveConnection() throws Exception {
        return this.createConnection();
    }

    protected Connection createSendConnection() throws Exception {
        return this.createConnection();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    protected void tearDown() throws Exception {
        this.session.close();
        this.receiveSession.close();
        this.sendConnection.close();
        this.receiveConnection.close();
    }
}

