/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.activemq.test.TestSupport;

public class JmsSendReceiveTestSupport
extends TestSupport
implements MessageListener {
    protected int messageCount = 100;
    protected String[] data;
    protected Session session;
    protected Session consumeSession;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected List messages = this.createConcurrentList();
    protected boolean topic = true;
    protected boolean durable = false;
    protected int deliveryMode = 2;
    protected boolean verbose = false;
    protected boolean useSeparateSession = false;
    protected Latch doneLatch = new Latch();

    public void testSendReceive() throws Exception {
        this.messages.clear();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            if (this.verbose) {
                System.out.println("About to send a message: " + message + " with text: " + this.data[i]);
            }
            this.producer.send(this.producerDestination, (Message)message);
        }
        this.assertMessagesAreReceived();
        System.out.println("" + this.data.length + " messages(s) received, closing down connections");
    }

    protected void assertMessagesAreReceived() throws JMSException {
        this.waitForMessagesToBeDelivered();
        this.assertMessagesReceivedAreValid(this.messages);
    }

    protected void assertMessagesReceivedAreValid(List receivedMessages) throws JMSException {
        List<Object> copyOfMessages = Arrays.asList(receivedMessages.toArray());
        int counter = 0;
        if (this.data.length != copyOfMessages.size()) {
            Iterator<Object> iter = copyOfMessages.iterator();
            while (iter.hasNext()) {
                TextMessage message = (TextMessage)iter.next();
                System.out.println("<== " + counter++ + " = " + message);
            }
        }
        JmsSendReceiveTestSupport.assertEquals((String)"Not enough messages received", (int)this.data.length, (int)receivedMessages.size());
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage received = (TextMessage)receivedMessages.get(i);
            String text = received.getText();
            if (this.verbose) {
                System.out.println("Received Text: " + text);
            }
            JmsSendReceiveTestSupport.assertEquals((String)("Message: " + i), (String)this.data[i], (String)text);
        }
    }

    protected void waitForMessagesToBeDelivered() {
        try {
            this.doneLatch.attempt(30000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        int i;
        super.setUp();
        String temp = System.getProperty("messageCount");
        if (temp != null && (i = Integer.parseInt(temp)) > 0) {
            this.messageCount = i;
        }
        System.out.println("Message count for test case is: " + this.messageCount);
        this.data = new String[this.messageCount];
        for (i = 0; i < this.messageCount; ++i) {
            this.data[i] = "Text for message: " + i + " at " + new Date();
        }
    }

    public synchronized void onMessage(Message message) {
        this.consumeMessage(message, this.messages);
    }

    protected void consumeMessage(Message message, List messageList) {
        if (this.verbose) {
            System.out.println("Received message: " + message);
        }
        messageList.add(message);
        if (messageList.size() >= this.data.length) {
            this.doneLatch.release();
        }
    }

    protected List createConcurrentList() {
        return Collections.synchronizedList(new ArrayList());
    }
}

