/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.activemq.ActiveMQConnectionFactory;

public class JmsResourceProvider {
    private String serverUri = "vm://localhost";
    private boolean transacted = false;
    private int ackMode = 1;
    private boolean isTopic;
    private int deliveryMode = 2;
    private String durableName = "DummyName";
    private String clientID = this.getClass().getName();

    public ConnectionFactory createConnectionFactory() throws JMSException {
        return new ActiveMQConnectionFactory(this.serverUri);
    }

    public Connection createConnection(ConnectionFactory cf) throws JMSException {
        Connection connection = cf.createConnection();
        if (this.isDurableSubscriber()) {
            connection.setClientID(this.getClientID());
        }
        return connection;
    }

    public Session createSession(Connection conn) throws JMSException {
        return conn.createSession(this.transacted, this.ackMode);
    }

    public MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.isDurableSubscriber()) {
            return session.createDurableSubscriber((Topic)destination, this.durableName);
        }
        return session.createConsumer(destination);
    }

    public ConnectionConsumer createConnectionConsumer(Connection connection, Destination destination, ServerSessionPool ssp) throws JMSException {
        return connection.createConnectionConsumer(destination, null, ssp, 1);
    }

    public MessageProducer createProducer(Session session, Destination destination) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        return producer;
    }

    public Destination createDestination(Session session, String name) throws JMSException {
        if (this.isTopic) {
            return session.createTopic("TOPIC." + name);
        }
        return session.createQueue("QUEUE." + name);
    }

    public boolean isDurableSubscriber() {
        return this.isTopic && this.deliveryMode == 2;
    }

    public int getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(int ackMode) {
        this.ackMode = ackMode;
    }

    public boolean isTopic() {
        return this.isTopic;
    }

    public void setTopic(boolean isTopic) {
        this.isTopic = isTopic;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void setDurableName(String durableName) {
        this.durableName = durableName;
    }
}

