/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.impl.BrokerContainerImpl;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTopic;
import org.activemq.pool.PooledConnectionFactory;
import org.springframework.jms.core.JmsTemplate;

public class EmbeddedBrokerTestSupport
extends TestCase {
    protected BrokerContainer broker;
    protected String bindAddress = "tcp://localhost:61616";
    protected ConnectionFactory connectionFactory;
    protected boolean useTopic = false;
    protected Destination destination;
    protected JmsTemplate template;
    private boolean usePooledConnectionWithTemplate = true;

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        this.broker.start();
        this.connectionFactory = this.createConnectionFactory();
        this.destination = this.createDestination();
        this.template = this.createJmsTemplate();
        this.template.setDefaultDestination(this.destination);
        this.template.setPubSubDomain(this.useTopic);
        this.template.afterPropertiesSet();
    }

    protected void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected JmsTemplate createJmsTemplate() {
        if (this.usePooledConnectionWithTemplate) {
            return new JmsTemplate((ConnectionFactory)new PooledConnectionFactory(this.bindAddress));
        }
        return new JmsTemplate(this.connectionFactory);
    }

    protected Destination createDestination() {
        return this.createDestination(this.getDestinationString());
    }

    protected Destination createDestination(String subject) {
        if (this.useTopic) {
            return new ActiveMQTopic(subject);
        }
        return new ActiveMQQueue(subject);
    }

    protected String getDestinationString() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.bindAddress);
    }

    protected BrokerContainer createBroker() throws Exception {
        BrokerContainerImpl answer = new BrokerContainerImpl();
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected Connection createConnection() throws Exception {
        return this.connectionFactory.createConnection();
    }
}

