/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.test;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import junit.framework.Assert;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.broker.BrokerContainer;
import org.activemq.message.ActiveMQDestination;
import org.activemq.service.DeadLetterPolicy;
import org.activemq.service.MessageIdentity;
import org.activemq.spring.SpringBrokerContainerFactory;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.RecoveryListener;
import org.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.activemq.store.jdbc.PersistenceAdapterTest;
import org.activemq.test.TestSupport;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DeadLetterManualExpiryTest
extends TestSupport {
    private static final int MESSAGE_COUNT = 10;
    private static final long TIME_TO_LIVE = 250L;
    private static final long CLEANUP_REPEAT_INTERVAL = 2000L;
    private ActiveMQConnectionFactory factory;
    private Connection connection;
    private Session session;
    private MessageConsumer consumer;
    private MessageProducer producer;
    private ActiveMQDestination destination;
    private int deliveryMode = 2;
    private boolean durableSubscriber = false;
    private static String BROKER_CONFIG = "org/activemq/spring/activemq.xml";
    private BrokerContainer brokerContainer;
    private JDBCPersistenceAdapter adapter;
    protected boolean autoExpire = false;
    protected boolean expirePersistentMessagesOnly = false;

    protected void setUp() throws Exception {
        super.setUp();
        this.brokerContainer = this.createBrokerContainer();
        this.brokerContainer.start();
        this.factory = this.createConnectionFactory();
        this.connection = this.factory.createConnection();
        this.connection.setClientID(this.toString());
        this.session = this.connection.createSession(false, 1);
    }

    protected BrokerContainer createBrokerContainer() {
        BrokerContainer container = SpringBrokerContainerFactory.newInstance((Resource)new ClassPathResource(BROKER_CONFIG), (String)"broker");
        this.adapter = (JDBCPersistenceAdapter)PersistenceAdapterTest.createDefault(true);
        this.adapter.setAutoCleanupExpiredMessages(this.autoExpire);
        this.adapter.setCleanupRepeatInterval(2000L);
        this.adapter.setDeleteExpiredMessages(true);
        this.adapter.setBrokerContainer(container);
        container.setPersistenceAdapter((PersistenceAdapter)this.adapter);
        return container;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerContainer, "tcp://localhost:61626");
        factory.setUseEmbeddedBroker(false);
        return factory;
    }

    protected void tearDown() throws Exception {
        this.connection.close();
        this.brokerContainer.stop();
    }

    protected void doTest() throws Exception {
        this.produceAndConsumeMessages();
        if (!this.topic || this.deliveryMode == 2) {
            this.verifyDeadLetterQueue();
        }
    }

    protected void produceAndConsumeMessages() throws JMSException, InterruptedException {
        int i;
        String destinationName = ((Object)((Object)this)).getClass().getName();
        this.destination = (ActiveMQDestination)this.createDestination(destinationName);
        this.producer = this.session.createProducer((Destination)this.destination);
        this.producer.setDeliveryMode(this.deliveryMode);
        this.producer.setTimeToLive(250L);
        this.consumer = this.durableSubscriber ? this.session.createDurableSubscriber((Topic)this.destination, this.destination.toString()) : this.session.createConsumer((Destination)this.destination);
        for (i = 0; i < 10; ++i) {
            TextMessage message = this.session.createTextMessage("msg: " + i);
            this.producer.send((Message)message);
        }
        Thread.sleep(500L);
        this.connection.start();
        if (this.autoExpire) {
            Thread.sleep(4000L);
            this.adapter.createQueueMessageStore(destinationName).recover(new RecoveryListener(){

                public void recoverMessage(MessageIdentity messageIdentity) throws JMSException {
                    Assert.assertTrue((String)("Queue should be empty, found message: " + messageIdentity), (boolean)false);
                }
            });
        } else {
            for (i = 0; i < 10; ++i) {
                Message msg = this.consumer.receive(10L);
                DeadLetterManualExpiryTest.assertNull((String)"Should be null message", (Object)msg);
            }
        }
    }

    protected void verifyDeadLetterQueue() throws JMSException, InterruptedException {
        DeadLetterPolicy dlq = this.brokerContainer.getBroker().getDeadLetterPolicy();
        String dlqName = dlq.getDeadLetterNameFromDestination(this.destination);
        Queue dlqDestination = this.session.createQueue(dlqName);
        MessageConsumer dlqConsumer = this.session.createConsumer((Destination)dlqDestination);
        for (int i = 0; i < 10; ++i) {
            Message msg = dlqConsumer.receive(1000L);
            DeadLetterManualExpiryTest.assertNotNull((String)"Should find message in dead letter queue", (Object)msg);
        }
        Thread.sleep(2000L);
        this.adapter.createQueueMessageStore(dlqName).recover(new RecoveryListener(){

            public void recoverMessage(MessageIdentity messageIdentity) throws JMSException {
                Assert.assertTrue((String)("Dead letter queue should be empty, found message: " + messageIdentity), (boolean)false);
            }
        });
    }

    public void testTransientTopicMessageExpiration() throws Exception {
        this.topic = true;
        this.deliveryMode = 1;
        this.durableSubscriber = false;
        this.doTest();
    }

    public void testDurableTopicMessageExpiration() throws Exception {
        this.topic = true;
        this.deliveryMode = 2;
        this.durableSubscriber = true;
        this.doTest();
    }

    public void testTransientQueueMessageExpiration() throws Exception {
        if (!this.expirePersistentMessagesOnly) {
            this.topic = false;
            this.deliveryMode = 1;
            this.durableSubscriber = false;
            this.doTest();
        }
    }

    public void testDurableQueueMessageExpiration() throws Exception {
        this.topic = false;
        this.deliveryMode = 2;
        this.durableSubscriber = false;
        this.doTest();
    }
}

