/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.streams;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.streams.JMSInputStream;
import org.activemq.streams.JMSOutputStream;

public class JMSInputStreamTest
extends TestCase {
    protected Connection producerConnection;
    protected Connection consumerConnection;
    protected DataOutputStream out;
    protected DataInputStream in;

    protected void setUp() throws Exception {
        super.setUp();
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("vm://localhost");
        this.producerConnection = fac.createConnection();
        Session s = this.producerConnection.createSession(false, 1);
        Topic dest = s.createTopic(((Object)((Object)this)).getClass().getName());
        MessageProducer producer = s.createProducer((Destination)dest);
        this.consumerConnection = fac.createConnection();
        s = this.consumerConnection.createSession(false, 1);
        MessageConsumer consumer = s.createConsumer((Destination)dest);
        this.consumerConnection.start();
        this.out = new DataOutputStream((OutputStream)new JMSOutputStream(producer));
        this.in = new DataInputStream((InputStream)new JMSInputStream(consumer));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.consumerConnection.close();
        this.producerConnection.close();
    }

    public void testStreams() throws Exception {
        int i;
        this.out.writeInt(4);
        this.out.flush();
        JMSInputStreamTest.assertTrue((this.in.readInt() == 4 ? 1 : 0) != 0);
        this.out.writeFloat(2.3f);
        this.out.flush();
        JMSInputStreamTest.assertTrue((this.in.readFloat() == 2.3f ? 1 : 0) != 0);
        String str = "this is a test string";
        this.out.writeUTF(str);
        this.out.flush();
        JMSInputStreamTest.assertTrue((boolean)this.in.readUTF().equals(str));
        for (i = 0; i < 100; ++i) {
            this.out.writeLong(i);
        }
        this.out.flush();
        for (i = 0; i < 100; ++i) {
            JMSInputStreamTest.assertTrue((this.in.readLong() == (long)i ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLarge() throws Exception {
        int TEST_DATA = 23;
        int DATA_LENGTH = 4096;
        int COUNT = 1024;
        byte[] data = new byte[4096];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 23;
        }
        final SynchronizedBoolean complete = new SynchronizedBoolean(false);
        Thread runner = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    for (int x = 0; x < 1024; ++x) {
                        byte[] b = new byte[2048];
                        JMSInputStreamTest.this.in.readFully(b);
                        for (int i = 0; i < b.length; ++i) {
                            Assert.assertTrue((b[i] == 23 ? 1 : 0) != 0);
                        }
                    }
                    complete.set(true);
                    SynchronizedBoolean x = complete;
                    synchronized (x) {
                        complete.notify();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        runner.start();
        for (int i = 0; i < 1024; ++i) {
            this.out.write(data);
        }
        this.out.flush();
        SynchronizedBoolean synchronizedBoolean = complete;
        synchronized (synchronizedBoolean) {
            if (!complete.get()) {
                complete.wait(30000L);
            }
        }
        JMSInputStreamTest.assertTrue((boolean)complete.get());
    }

    public JMSInputStreamTest(String arg0) {
        super(arg0);
    }
}

