/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import javax.jms.JMSException;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TransactionStore;
import org.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class PersistenceAdapterTest
extends TestCase {
    private PersistenceAdapter persistenceAdapter;
    private TransactionStore preparedTransactionStore;
    private boolean initialized;

    public void testStartAndStop() throws Exception {
        if (this.persistenceAdapter == null) {
            this.persistenceAdapter = this.createPersistenceAdapter();
        }
        this.persistenceAdapter.start();
        this.preparedTransactionStore = this.persistenceAdapter.createTransactionStore();
        this.preparedTransactionStore.start();
        this.preparedTransactionStore.stop();
        this.persistenceAdapter.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceAdapter createPersistenceAdapter() throws JMSException {
        try {
            PersistenceAdapter persistenceAdapter = PersistenceAdapterTest.createDefault(!this.initialized);
            return persistenceAdapter;
        }
        finally {
            this.initialized = true;
        }
    }

    public static PersistenceAdapter createDefault(boolean cleanup) {
        EmbeddedDataSource ds = new EmbeddedDataSource();
        ds.setDatabaseName("testdb");
        ds.setCreateDatabase("create");
        JDBCPersistenceAdapter rc = new JDBCPersistenceAdapter((DataSource)ds, (WireFormat)new DefaultWireFormat());
        rc.setDropTablesOnStartup(cleanup);
        return rc;
    }
}

