/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.spring;

import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.activemq.spring.SpringConsumer;
import org.activemq.spring.SpringProducer;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SpringTest
extends TestCase {
    protected XmlBeanFactory factory;
    protected SpringConsumer consumer;
    protected SpringProducer producer;

    public void testSenderWithSpringXmlUsingJNDI() throws Exception {
        String config = "org/activemq/spring/spring-jndi.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXml() throws Exception {
        String config = "org/activemq/spring/spring.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithPooledSpringXml() throws Exception {
        String config = "org/activemq/spring/spring-pool.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlAndQueue() throws Exception {
        String config = "org/activemq/spring/spring-queue.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlEmbeddedBrokerConfiguredViaXml() throws Exception {
        String config = "org/activemq/spring/spring-embedded.xml";
        this.assertSenderConfig(config);
    }

    protected void assertSenderConfig(String config) throws Exception {
        this.factory = new XmlBeanFactory((Resource)new ClassPathResource(config));
        this.consumer = (SpringConsumer)this.factory.getBean("consumer");
        SpringTest.assertTrue((String)"Found a valid consumer", (this.consumer != null ? 1 : 0) != 0);
        this.consumer.start();
        this.producer = (SpringProducer)this.factory.getBean("producer");
        SpringTest.assertTrue((String)"Found a valid producer", (this.producer != null ? 1 : 0) != 0);
        this.consumer.flushMessages();
        this.producer.start();
        this.consumer.waitForMessagesToArrive(this.producer.getMessageCount());
        List messages = this.consumer.flushMessages();
        System.out.println("Consumer has received messages....");
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            Object message = iter.next();
            System.out.println("Received: " + message);
        }
        SpringTest.assertEquals((String)"Message count", (int)this.producer.getMessageCount(), (int)messages.size());
    }

    protected void tearDown() throws Exception {
        if (this.consumer != null) {
            this.consumer.stop();
        }
        if (this.producer != null) {
            this.producer.stop();
        }
        if (this.factory != null) {
            this.factory.destroySingletons();
        }
    }
}

