/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.spring;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;

public class ConsumerBean
implements MessageListener {
    private List messages = new ArrayList();
    private Object semaphore;

    public ConsumerBean() {
        this(new Object());
    }

    public ConsumerBean(Object semaphore) {
        this.semaphore = semaphore;
    }

    public synchronized List flushMessages() {
        ArrayList answer = new ArrayList(this.messages);
        this.messages.clear();
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onMessage(Message message) {
        this.messages.add(message);
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessageToArrive() {
        long start;
        block5: {
            System.out.println("Waiting for message to arrive");
            start = System.currentTimeMillis();
            try {
                if (!this.hasReceivedMessage()) break block5;
                Object object = this.semaphore;
                synchronized (object) {
                    this.semaphore.wait(4000L);
                }
            }
            catch (InterruptedException e) {
                System.out.println("Caught: " + e);
            }
        }
        long end = System.currentTimeMillis() - start;
        System.out.println("End of wait for " + end + " millis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessagesToArrive(int messageCount) {
        System.out.println("Waiting for message to arrive");
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            try {
                if (this.hasReceivedMessages(messageCount)) break;
                Object object = this.semaphore;
                synchronized (object) {
                    this.semaphore.wait(1000L);
                    continue;
                }
            }
            catch (InterruptedException e) {
                System.out.println("Caught: " + e);
            }
        }
        long end = System.currentTimeMillis() - start;
        System.out.println("End of wait for " + end + " millis");
    }

    protected boolean hasReceivedMessage() {
        return this.messages.isEmpty();
    }

    protected synchronized boolean hasReceivedMessages(int messageCount) {
        return this.messages.size() >= messageCount;
    }
}

