/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service;

import javax.jms.Destination;
import junit.framework.TestCase;
import org.activemq.broker.BrokerClient;
import org.activemq.broker.BrokerClientStub;
import org.activemq.io.util.MemoryBoundedObjectManager;
import org.activemq.io.util.MemoryBoundedQueueManager;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQQueue;
import org.activemq.service.boundedvm.TransientQueueBoundedMessageManager;

public class TransientQueueGarbageCollectionTest
extends TestCase {
    private static final int MESSAGE_SIZE = 1024;
    private MemoryBoundedObjectManager memoryManager;
    private MemoryBoundedQueueManager queueManager;
    private TransientQueueBoundedMessageManager transientQueueMCM;
    protected BrokerClientStub client;

    public void testGCNoSubscribers() throws Exception {
        ActiveMQMessage msg = this.createMessage();
        this.runGCTest(msg);
    }

    public void testGCExpiredMessage() throws Exception {
        ActiveMQMessage msg = this.createMessage();
        msg.setJMSExpiration(1L);
        Thread.sleep(2L);
        this.runGCTest(msg);
    }

    protected String getDestination() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    protected ActiveMQMessage createMessage() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSDestination((Destination)new ActiveMQQueue(this.getDestination()));
        msg.setMemoryUsage(1024);
        msg.setJMSDeliveryMode(1);
        return msg;
    }

    protected void runGCTest(ActiveMQMessage msg) throws Exception {
        System.out.println("Queue capacity before: " + this.queueManager.getCurrentCapacity());
        this.transientQueueMCM.sendMessage((BrokerClient)this.client, msg);
        System.out.println("Queue capacity after: " + this.queueManager.getCurrentCapacity());
        TransientQueueGarbageCollectionTest.assertTrue((String)"Memory must be full by now", (boolean)this.memoryManager.isFull());
        TransientQueueGarbageCollectionTest.assertTrue((String)"Total memory used must be equal to 1024", (this.memoryManager.getTotalMemoryUsedSize() >= 1024L ? 1 : 0) != 0);
        Thread.sleep(2000L);
        TransientQueueGarbageCollectionTest.assertTrue((String)"Memory must have been freed by now", (this.memoryManager.getTotalMemoryUsedSize() == 0L ? 1 : 0) != 0);
    }

    public void setUp() throws Exception {
        this.memoryManager = new MemoryBoundedObjectManager("testmanager", 1024L);
        TransientQueueGarbageCollectionTest.assertEquals((String)"Total memory used must be zero", (long)0L, (long)this.memoryManager.getTotalMemoryUsedSize());
        this.queueManager = new MemoryBoundedQueueManager(this.memoryManager);
        this.transientQueueMCM = new TransientQueueBoundedMessageManager(this.queueManager, null, null);
        this.transientQueueMCM.start();
        this.client = new BrokerClientStub();
    }

    public void tearDown() throws Exception {
        this.transientQueueMCM.stop();
        super.tearDown();
    }
}

