/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service;

import javax.jms.JMSException;
import org.activemq.broker.Broker;
import org.activemq.broker.BrokerClient;
import org.activemq.broker.BrokerClientStub;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.BrokerTestSupport;

public class TopicBrokerTest
extends BrokerTestSupport {
    protected BrokerClient client;
    protected Object semaphore = new Object();

    public void testSendingMessagesToVariousDestinations() throws Exception {
        BrokerClientStub queueA = new BrokerClientStub(this.semaphore);
        BrokerClientStub queueB = new BrokerClientStub(this.semaphore);
        BrokerClientStub queueC = new BrokerClientStub(this.semaphore);
        BrokerClientStub queueD = new BrokerClientStub(this.semaphore);
        this.addSubscription("FOO.BAR", null, queueA, this.isTopic());
        this.addSubscription("FOO.*", null, queueB, this.isTopic());
        this.addSubscription("BAR.*", "priority = 123", queueC, this.isTopic());
        this.addSubscription("BAR.*", "x = 'ABC'", queueD, this.isTopic());
        ActiveMQMessage message = this.dispatchMessage(this.broker, "FOO.BAR");
        queueA.waitForMessageToArrive();
        if (this.isTopic()) {
            TopicBrokerTest.assertEquals((String)"queueA", (boolean)true, (boolean)queueA.flushMessages().contains(message));
            TopicBrokerTest.assertEquals((String)"queueB", (boolean)true, (boolean)queueB.flushMessages().contains(message));
        } else {
            boolean atA = queueA.flushMessages().contains(message);
            boolean atB = queueB.flushMessages().contains(message);
            TopicBrokerTest.assertTrue((String)("Sent to queueA or queueB. a: " + atA + " b: " + atB), (atA && !atB || !atA && atB ? 1 : 0) != 0);
        }
        TopicBrokerTest.assertEquals((String)"queueC", (boolean)false, (boolean)queueC.flushMessages().contains(message));
        message = this.dispatchMessage(this.broker, "FOO.XYZ");
        queueB.waitForMessageToArrive();
        TopicBrokerTest.assertEquals((String)"queueA", (boolean)false, (boolean)queueA.flushMessages().contains(message));
        TopicBrokerTest.assertEquals((String)"queueC", (boolean)false, (boolean)queueC.flushMessages().contains(message));
        TopicBrokerTest.assertEquals((String)"queueD", (boolean)false, (boolean)queueD.flushMessages().contains(message));
        TopicBrokerTest.assertEquals((String)"queueB", (boolean)true, (boolean)queueB.flushMessages().contains(message));
        message = this.createMessage("BAR.XYZ");
        message.setIntProperty("priority", 123);
        this.broker.sendMessage(this.client, message);
        queueC.waitForMessageToArrive();
        TopicBrokerTest.assertEquals((String)"queueA", (boolean)false, (boolean)queueA.flushMessages().contains(message));
        TopicBrokerTest.assertEquals((String)"queueB", (boolean)false, (boolean)queueB.flushMessages().contains(message));
        TopicBrokerTest.assertEquals((String)"queueC", (boolean)true, (boolean)queueC.flushMessages().contains(message));
        TopicBrokerTest.assertEquals((String)"queueD", (boolean)false, (boolean)queueD.flushMessages().contains(message));
        message = this.createMessage("BAR.XYZ");
        message.setStringProperty("x", "ABC");
        this.broker.sendMessage(this.client, message);
        queueD.waitForMessageToArrive();
        TopicBrokerTest.assertEquals((String)"queueA", (boolean)false, (boolean)queueA.flushMessages().contains(message));
        TopicBrokerTest.assertEquals((String)"queueB", (boolean)false, (boolean)queueB.flushMessages().contains(message));
        TopicBrokerTest.assertEquals((String)"queueC", (boolean)false, (boolean)queueC.flushMessages().contains(message));
        TopicBrokerTest.assertEquals((String)"queueD", (boolean)true, (boolean)queueD.flushMessages().contains(message));
    }

    protected void addSubscription(String subject, String selector, BrokerClient client, boolean topic) throws JMSException {
        ConsumerInfo info = this.createConsumer(subject, selector);
        this.broker.addMessageConsumer(client, info);
    }

    protected ActiveMQMessage dispatchMessage(Broker broker, String subject) throws JMSException, InterruptedException {
        ActiveMQMessage message = this.createMessage(subject);
        broker.sendMessage(this.client, message);
        return message;
    }
}

