/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service;

import java.util.List;
import org.activemq.broker.BrokerClient;
import org.activemq.broker.BrokerClientStub;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.BrokerTestSupport;

public class SimpleTopicBrokerTest
extends BrokerTestSupport {
    protected BrokerClientStub client = new BrokerClientStub();
    protected ConsumerInfo consumerInfo;

    public void testDispatch() throws Exception {
        ActiveMQMessage message = this.createMessage(this.getDestination());
        List messages = this.client.flushMessages();
        SimpleTopicBrokerTest.assertEquals((String)"No messages received yet", (int)0, (int)messages.size());
        this.broker.sendMessage((BrokerClient)this.client, message);
        this.client.waitForMessageToArrive();
        messages = this.client.flushMessages();
        SimpleTopicBrokerTest.assertEquals((String)"Expected a single message", (int)1, (int)messages.size());
        System.out.println("Received message: " + messages.get(0));
    }

    protected String getDestination() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.consumerInfo = this.createConsumer(this.getDestination());
        this.broker.addMessageConsumer((BrokerClient)this.client, this.consumerInfo);
    }

    protected void tearDown() throws Exception {
        if (this.broker != null && this.client != null && this.consumerInfo != null) {
            this.broker.removeMessageConsumer((BrokerClient)this.client, this.consumerInfo);
        }
        super.tearDown();
    }
}

