/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service;

import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.service.QueueList;
import org.activemq.service.QueueListEntry;

public abstract class QueueListTestSupport
extends TestCase {
    protected QueueList list;

    public void testAddFirst() throws Exception {
        this.beginTransaction();
        this.list.clear();
        QueueListTestSupport.assertTrue((boolean)this.list.isEmpty());
        this.list.addFirst((Object)"D");
        this.list.addFirst((Object)"C");
        this.list.add(0, (Object)"B");
        this.list.add(0, (Object)"A");
        this.assertListEquals(this.list, new Object[]{"A", "B", "C", "D"});
        QueueListEntry entry = this.list.getFirstEntry();
        QueueListTestSupport.assertEquals((Object)"A", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"B", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"C", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"D", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals(null, (Object)entry);
        entry = this.list.getLastEntry();
        QueueListTestSupport.assertEquals((Object)"D", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"C", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"B", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"A", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals(null, (Object)entry);
        this.list.set(0, (Object)"X");
        this.list.set(1, (Object)"Y");
        this.list.set(2, (Object)"Z");
        this.list.set(3, (Object)"!");
        this.assertListEquals(this.list, new Object[]{"X", "Y", "Z", "!"});
        this.list.clear();
        QueueListTestSupport.assertTrue((String)"List should now be empty", (boolean)this.list.isEmpty());
        this.commitTransaction();
    }

    public void testAddAndAddLast() throws Exception {
        this.beginTransaction();
        this.list.clear();
        QueueListTestSupport.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.addLast((Object)"C");
        this.list.addLast((Object)"D");
        this.assertListEquals(this.list, new Object[]{"A", "B", "C", "D"});
        QueueListEntry entry = this.list.getFirstEntry();
        QueueListTestSupport.assertEquals((Object)"A", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"B", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"C", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"D", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals(null, (Object)entry);
        entry = this.list.getLastEntry();
        QueueListTestSupport.assertEquals((Object)"D", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"C", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"B", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"A", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals(null, (Object)entry);
        this.list.clear();
        QueueListTestSupport.assertTrue((String)"List should now be empty", (boolean)this.list.isEmpty());
        this.commitTransaction();
    }

    public void testAddAtFrontBackAndMiddle() throws Exception {
        this.beginTransaction();
        this.list.clear();
        QueueListTestSupport.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.addFirst((Object)"C");
        this.list.addLast((Object)"D");
        this.list.add(1, (Object)"E");
        this.list.add(5, (Object)"F");
        this.assertListEquals(this.list, new Object[]{"C", "E", "A", "B", "D", "F"});
        QueueListTestSupport.assertEquals((Object)"C", (Object)this.list.getFirst());
        QueueListTestSupport.assertEquals((Object)"F", (Object)this.list.getLast());
        QueueListEntry entry = this.list.getLastEntry();
        QueueListTestSupport.assertEquals((Object)"F", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"D", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"B", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"A", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"E", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals((Object)"C", (Object)entry.getElement());
        entry = this.list.getPrevEntry(entry);
        QueueListTestSupport.assertEquals(null, (Object)entry);
        entry = this.list.getFirstEntry();
        QueueListTestSupport.assertEquals((Object)"C", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"E", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"A", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"B", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"D", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals((Object)"F", (Object)entry.getElement());
        entry = this.list.getNextEntry(entry);
        QueueListTestSupport.assertEquals(null, (Object)entry);
        QueueListTestSupport.assertTrue((boolean)this.list.contains((Object)"C"));
        QueueListTestSupport.assertTrue((boolean)this.list.contains((Object)"F"));
        QueueListTestSupport.assertTrue((boolean)this.list.contains((Object)"B"));
        QueueListTestSupport.assertTrue((!this.list.contains((Object)"Z") ? 1 : 0) != 0);
        QueueListTestSupport.assertTrue((!this.list.isEmpty() ? 1 : 0) != 0);
        QueueListTestSupport.assertEquals((int)6, (int)this.list.size());
        this.list.removeFirst();
        QueueListTestSupport.assertEquals((Object)"E", (Object)this.list.getFirst());
        this.list.removeLast();
        QueueListTestSupport.assertEquals((Object)"D", (Object)this.list.getLast());
        this.list.clear();
        QueueListTestSupport.assertTrue((String)"List should now be empty", (boolean)this.list.isEmpty());
        this.commitTransaction();
    }

    public void testEmptyList() throws Exception {
        this.beginTransaction();
        this.list.clear();
        QueueListTestSupport.assertTrue((boolean)this.list.isEmpty());
        QueueListTestSupport.assertEquals((int)0, (int)this.list.size());
        QueueListTestSupport.assertEquals(null, (Object)this.list.getFirst());
        QueueListTestSupport.assertEquals(null, (Object)this.list.getLast());
        QueueListTestSupport.assertEquals((int)-1, (int)this.list.indexOf((Object)"foo"));
        QueueListTestSupport.assertEquals((int)-1, (int)this.list.lastIndexOf((Object)"foo"));
        this.commitTransaction();
    }

    public void testIndexOf() throws Exception {
        this.beginTransaction();
        this.list.clear();
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"B");
        this.list.add((Object)"D");
        this.assertListEquals(this.list, new Object[]{"A", "B", "C", "B", "D"});
        QueueListTestSupport.assertEquals((int)0, (int)this.list.indexOf((Object)"A"));
        QueueListTestSupport.assertEquals((int)1, (int)this.list.indexOf((Object)"B"));
        QueueListTestSupport.assertEquals((int)2, (int)this.list.indexOf((Object)"C"));
        QueueListTestSupport.assertEquals((int)4, (int)this.list.indexOf((Object)"D"));
        QueueListTestSupport.assertEquals((int)-1, (int)this.list.indexOf((Object)"cheese"));
        QueueListTestSupport.assertEquals((int)0, (int)this.list.lastIndexOf((Object)"A"));
        QueueListTestSupport.assertEquals((int)3, (int)this.list.lastIndexOf((Object)"B"));
        QueueListTestSupport.assertEquals((int)2, (int)this.list.lastIndexOf((Object)"C"));
        QueueListTestSupport.assertEquals((int)4, (int)this.list.lastIndexOf((Object)"D"));
        QueueListTestSupport.assertEquals((int)-1, (int)this.list.lastIndexOf((Object)"cheese"));
        this.commitTransaction();
    }

    protected void beginTransaction() throws JMSException {
    }

    protected void commitTransaction() throws JMSException {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.list = this.createQueueList();
    }

    protected abstract QueueList createQueueList() throws JMSException;

    protected void assertListEquals(QueueList list, Object[] expected) throws JMSException {
        Object expectedValue;
        int i;
        this.assertArrayEquals(expected, list.toArray());
        for (int i2 = 0; i2 < expected.length; ++i2) {
            Object expectedValue2 = expected[i2];
            Object value = list.get(i2);
            QueueListTestSupport.assertEquals((String)("get(int) at index: " + i2), (Object)expectedValue2, (Object)value);
        }
        QueueListEntry entry = list.getFirstEntry();
        for (i = 0; i < expected.length; ++i) {
            expectedValue = expected[i];
            QueueListTestSupport.assertTrue((String)("Should have an entry for index: " + i), (entry != null ? 1 : 0) != 0);
            QueueListTestSupport.assertEquals((String)("element for entry at index: " + i), (Object)expectedValue, (Object)entry.getElement());
            entry = list.getNextEntry(entry);
        }
        QueueListTestSupport.assertTrue((String)"entry should now be null", (entry == null ? 1 : 0) != 0);
        entry = list.getLastEntry();
        for (i = expected.length - 1; i >= 0; --i) {
            expectedValue = expected[i];
            QueueListTestSupport.assertTrue((String)("Should have an entry for index: " + i), (entry != null ? 1 : 0) != 0);
            QueueListTestSupport.assertEquals((String)("element for entry at index: " + i), (Object)expectedValue, (Object)entry.getElement());
            entry = list.getPrevEntry(entry);
        }
        QueueListTestSupport.assertTrue((String)"entry should now be null", (entry == null ? 1 : 0) != 0);
        if (expected.length > 0) {
            QueueListTestSupport.assertEquals((String)"first value", (Object)expected[0], (Object)list.getFirst());
            QueueListTestSupport.assertEquals((String)"last value", (Object)expected[expected.length - 1], (Object)list.getLast());
            QueueListTestSupport.assertTrue((String)"Should not be empty!", (!list.isEmpty() ? 1 : 0) != 0);
        } else {
            QueueListTestSupport.assertTrue((String)"Should be empty!", (boolean)list.isEmpty());
        }
    }

    protected void assertArrayEquals(Object[] expected, Object[] objects) {
        String expectedText = this.asText(expected);
        String valueText = this.asText(objects);
        QueueListTestSupport.assertEquals((String)("Sizes wrong. Expected: " + expectedText + " was: " + valueText), (int)expected.length, (int)objects.length);
        for (int i = 0; i < expected.length; ++i) {
            Object expectedValue = expected[i];
            Object value = objects[i];
            QueueListTestSupport.assertEquals((String)("Value at index: " + i + ". Expected: " + expectedText + " was: " + valueText), (Object)expectedValue, (Object)value);
        }
    }

    protected String asText(Object[] objects) {
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(objects[i]);
        }
        buffer.append(" ]");
        return buffer.toString();
    }
}

