/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service;

import javax.jms.Destination;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.broker.Broker;
import org.activemq.broker.impl.DefaultBroker;
import org.activemq.filter.Filter;
import org.activemq.filter.FilterFactory;
import org.activemq.filter.FilterFactoryImpl;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.ConsumerInfo;
import org.activemq.util.IdGenerator;

public abstract class BrokerTestSupport
extends TestCase {
    private static final String BROKER_NAME = "TEST_BROKER";
    protected Broker broker;
    protected FilterFactory filterFactory = new FilterFactoryImpl();
    protected IdGenerator idGenerator = new IdGenerator();

    protected boolean isTopic() {
        return true;
    }

    protected ActiveMQMessage createMessage(String subject) {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setJMSMessageID(this.idGenerator.generateId());
        message.setJMSDestination((Destination)this.createDestination(subject));
        return message;
    }

    protected Filter createFilter(String subject, String selector) throws JMSException {
        return this.filterFactory.createFilter((Destination)this.createDestination(subject), selector);
    }

    protected ActiveMQDestination createDestination(String subject) {
        if (this.isTopic()) {
            return new ActiveMQTopic(subject);
        }
        return new ActiveMQQueue(subject);
    }

    protected Broker createStore() {
        return new DefaultBroker(BROKER_NAME);
    }

    protected ConsumerInfo createConsumer(String subject) {
        return this.createConsumer(subject, null);
    }

    protected ConsumerInfo createConsumer(String subject, String selector) {
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.idGenerator.generateId());
        info.setDestination(this.createDestination(subject));
        info.setSelector(selector);
        return info;
    }

    protected void setUp() throws Exception {
        this.broker = new DefaultBroker(BROKER_NAME);
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
    }
}

