/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.selector;

import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import junit.framework.TestCase;
import org.activemq.filter.Filter;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.ActiveMQTopic;
import org.activemq.selector.SelectorParser;

public class SelectorTest
extends TestCase {
    public void testXPathSelectors() throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setJMSType("xml");
        message.setText("<root><a key='first'/><b key='second'/></root>");
        this.assertSelector((Message)message, "XPATH 'root/a'", true);
        this.assertSelector((Message)message, "XPATH '//root/b'", true);
        this.assertSelector((Message)message, "XPATH 'root/c'", false);
        this.assertSelector((Message)message, "XPATH '//root/*[@key=''second'']'", true);
        this.assertSelector((Message)message, "XPATH '//root/*[@key=''third'']'", false);
        this.assertSelector((Message)message, "XPATH '//root/a[@key=''first'']'", true);
        this.assertSelector((Message)message, "XPATH '//root/a[@key=''second'']'", false);
    }

    public void testBasicSelectors() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "name = 'James'", true);
        this.assertSelector(message, "rank > 100", true);
        this.assertSelector(message, "rank >= 123", true);
        this.assertSelector(message, "rank >= 124", false);
    }

    public void testAndSelectors() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "name = 'James' and rank < 200", true);
        this.assertSelector(message, "name = 'James' and rank > 200", false);
        this.assertSelector(message, "name = 'Foo' and rank < 200", false);
        this.assertSelector(message, "unknown = 'Foo' and anotherUnknown < 200", false);
    }

    public void testOrSelectors() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "name = 'James' or rank < 200", true);
        this.assertSelector(message, "name = 'James' or rank > 200", true);
        this.assertSelector(message, "name = 'Foo' or rank < 200", true);
        this.assertSelector(message, "name = 'Foo' or rank > 200", false);
        this.assertSelector(message, "unknown = 'Foo' or anotherUnknown < 200", false);
    }

    public void testPlus() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "rank + 2 = 125", true);
        this.assertSelector(message, "(rank + 2) = 125", true);
        this.assertSelector(message, "125 = (rank + 2)", true);
        this.assertSelector(message, "rank + version = 125", true);
        this.assertSelector(message, "rank + 2 < 124", false);
        this.assertSelector(message, "name + '!' = 'James!'", true);
    }

    public void testMinus() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "rank - 2 = 121", true);
        this.assertSelector(message, "rank - version = 121", true);
        this.assertSelector(message, "rank - 2 > 122", false);
    }

    public void testMultiply() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "rank * 2 = 246", true);
        this.assertSelector(message, "rank * version = 246", true);
        this.assertSelector(message, "rank * 2 < 130", false);
    }

    public void testDivide() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "rank / version = 61.5", true);
        this.assertSelector(message, "rank / 3 > 100.0", false);
        this.assertSelector(message, "rank / 3 > 100", false);
        this.assertSelector(message, "version / 2 = 1", true);
    }

    public void testBetween() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "rank between 100 and 150", true);
        this.assertSelector(message, "rank between 10 and 120", false);
    }

    public void testIn() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "name in ('James', 'Bob', 'Gromit')", true);
        this.assertSelector(message, "name in ('Bob', 'James', 'Gromit')", true);
        this.assertSelector(message, "name in ('Gromit', 'Bob', 'James')", true);
        this.assertSelector(message, "name in ('Gromit', 'Bob', 'Cheddar')", false);
        this.assertSelector(message, "name not in ('Gromit', 'Bob', 'Cheddar')", true);
    }

    public void testIsNull() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "dummy is null", true);
        this.assertSelector(message, "dummy is not null", false);
        this.assertSelector(message, "name is not null", true);
        this.assertSelector(message, "name is null", false);
    }

    public void testLike() throws Exception {
        Message message = this.createMessage();
        message.setStringProperty("modelClassId", "com.whatever.something.foo.bar");
        message.setStringProperty("modelInstanceId", "170");
        message.setStringProperty("modelRequestError", "abc");
        message.setStringProperty("modelCorrelatedClientId", "whatever");
        this.assertSelector(message, "modelClassId LIKE 'com.whatever.something.%' AND modelInstanceId = '170' AND (modelRequestError IS NULL OR modelCorrelatedClientId = 'whatever')", true);
        message.setStringProperty("modelCorrelatedClientId", "shouldFailNow");
        this.assertSelector(message, "modelClassId LIKE 'com.whatever.something.%' AND modelInstanceId = '170' AND (modelRequestError IS NULL OR modelCorrelatedClientId = 'whatever')", false);
        message = this.createMessage();
        message.setStringProperty("modelClassId", "com.whatever.something.foo.bar");
        message.setStringProperty("modelInstanceId", "170");
        message.setStringProperty("modelCorrelatedClientId", "shouldNotMatch");
        this.assertSelector(message, "modelClassId LIKE 'com.whatever.something.%' AND modelInstanceId = '170' AND (modelRequestError IS NULL OR modelCorrelatedClientId = 'whatever')", true);
    }

    public void testMatsHenricsonUseCases() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "SessionserverId=1870414179", false);
        message.setLongProperty("SessionserverId", 1870414179L);
        this.assertSelector(message, "SessionserverId=1870414179", true);
        message.setLongProperty("SessionserverId", 1234L);
        this.assertSelector(message, "SessionserverId=1870414179", false);
        this.assertSelector(message, "Command NOT IN ('MirrorLobbyRequest', 'MirrorLobbyReply')", false);
        message.setStringProperty("Command", "Cheese");
        this.assertSelector(message, "Command NOT IN ('MirrorLobbyRequest', 'MirrorLobbyReply')", true);
        message.setStringProperty("Command", "MirrorLobbyRequest");
        this.assertSelector(message, "Command NOT IN ('MirrorLobbyRequest', 'MirrorLobbyReply')", false);
        message.setStringProperty("Command", "MirrorLobbyReply");
        this.assertSelector(message, "Command NOT IN ('MirrorLobbyRequest', 'MirrorLobbyReply')", false);
    }

    public void testFloatComparisons() throws Exception {
        Message message = this.createMessage();
        double x = 1.0;
        x = -1.1;
        x = 10.0;
        x = 11.0;
        x = -11.0;
        this.assertSelector(message, "1.0 < 1.1", true);
        this.assertSelector(message, "-1.1 < 1.0", true);
        this.assertSelector(message, "1.0E1 < 1.1E1", true);
        this.assertSelector(message, "-1.1E1 < 1.0E1", true);
        x = 1.0;
        x = 10.0;
        this.assertSelector(message, "1. < 1.1", true);
        this.assertSelector(message, "-1.1 < 1.", true);
        this.assertSelector(message, "1.E1 < 1.1E1", true);
        this.assertSelector(message, "-1.1E1 < 1.E1", true);
        x = 0.5;
        x = -0.5;
        x = 5.0;
        this.assertSelector(message, ".1 < .5", true);
        this.assertSelector(message, "-.5 < .1", true);
        this.assertSelector(message, ".1E1 < .5E1", true);
        this.assertSelector(message, "-.5E1 < .1E1", true);
        x = 4.0E10;
        x = -4.0E10;
        x = 5.0E10;
        x = 5.0E-10;
        this.assertSelector(message, "4E10 < 5E10", true);
        this.assertSelector(message, "5E8 < 5E10", true);
        this.assertSelector(message, "-4E10 < 2E10", true);
        this.assertSelector(message, "-5E8 < 2E2", true);
        this.assertSelector(message, "4E+10 < 5E+10", true);
        this.assertSelector(message, "4E-10 < 5E-10", true);
    }

    public void testStringQuoteParsing() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "quote = '''In God We Trust'''", true);
    }

    public void testLikeComparisons() throws Exception {
        Message message = this.createMessage();
        this.assertSelector(message, "quote LIKE '''In G_d We Trust'''", true);
        this.assertSelector(message, "quote LIKE '''In Gd_ We Trust'''", false);
        this.assertSelector(message, "quote NOT LIKE '''In G_d We Trust'''", false);
        this.assertSelector(message, "quote NOT LIKE '''In Gd_ We Trust'''", true);
        this.assertSelector(message, "foo LIKE '%oo'", true);
        this.assertSelector(message, "foo LIKE '%ar'", false);
        this.assertSelector(message, "foo NOT LIKE '%oo'", false);
        this.assertSelector(message, "foo NOT LIKE '%ar'", true);
        this.assertSelector(message, "foo LIKE '!_%' ESCAPE '!'", true);
        this.assertSelector(message, "quote LIKE '!_%' ESCAPE '!'", false);
        this.assertSelector(message, "foo NOT LIKE '!_%' ESCAPE '!'", false);
        this.assertSelector(message, "quote NOT LIKE '!_%' ESCAPE '!'", true);
        this.assertSelector(message, "punctuation LIKE '!#$&()*+,-./:;<=>?@[\\]^`{|}~'", true);
    }

    public void testInvalidSelector() throws Exception {
        Message message = this.createMessage();
        this.assertInvalidSelector(message, "3+5");
        this.assertInvalidSelector(message, "True AND 3+5");
        this.assertInvalidSelector(message, "=TEST 'test'");
    }

    protected Message createMessage() throws JMSException {
        Message message = this.createMessage("FOO.BAR");
        message.setObjectProperty("name", (Object)"James");
        message.setObjectProperty("location", (Object)"London");
        message.setIntProperty("rank", 123);
        message.setIntProperty("version", 2);
        message.setStringProperty("quote", "'In God We Trust'");
        message.setStringProperty("foo", "_foo");
        message.setStringProperty("punctuation", "!#$&()*+,-./:;<=>?@[\\]^`{|}~");
        return message;
    }

    protected void assertInvalidSelector(Message message, String text) throws JMSException {
        try {
            Filter selector = new SelectorParser().parse(text);
            SelectorTest.fail((String)"Created a valid selector");
        }
        catch (InvalidSelectorException invalidSelectorException) {
            // empty catch block
        }
    }

    protected void assertSelector(Message message, String text, boolean expected) throws JMSException {
        Filter selector = new SelectorParser().parse(text);
        SelectorTest.assertTrue((String)"Created a valid selector", (selector != null ? 1 : 0) != 0);
        boolean value = selector.matches(message);
        SelectorTest.assertEquals((String)("Selector for: " + text), (boolean)expected, (boolean)value);
    }

    protected Message createMessage(String subject) {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setJMSDestination(this.createDestination(subject));
        return message;
    }

    protected Destination createDestination(String subject) {
        return new ActiveMQTopic(subject);
    }
}

