/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.selector;

import junit.framework.TestCase;
import org.activemq.filter.ComparisonExpression;
import org.activemq.filter.Expression;
import org.activemq.filter.ExpressionFilter;
import org.activemq.filter.Filter;
import org.activemq.filter.LogicExpression;
import org.activemq.filter.PropertyExpression;
import org.activemq.filter.XPathExpression;
import org.activemq.selector.SelectorParser;

public class SelectorParserTest
extends TestCase {
    public void testParseXPath() throws Exception {
        Filter filter = this.parse("XPATH '//title[@lang=''eng'']'");
        SelectorParserTest.assertTrue((String)"Created ExpressionFilter filter", (boolean)(filter instanceof ExpressionFilter));
        Expression xpathExpression = ((ExpressionFilter)filter).getExpression();
        SelectorParserTest.assertTrue((String)"Created XPath expression", (boolean)(xpathExpression instanceof XPathExpression));
        System.out.println("Expression: " + xpathExpression);
    }

    public void testParseWithParensAround() throws Exception {
        String[] values = new String[]{"x = 1 and y = 2", "(x = 1) and (y = 2)", "((x = 1) and (y = 2))"};
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            System.out.println("Parsing: " + value);
            Filter filter = this.parse(value);
            SelectorParserTest.assertTrue((String)"Created ExpressionFilter filter", (boolean)(filter instanceof ExpressionFilter));
            Expression andExpression = ((ExpressionFilter)filter).getExpression();
            SelectorParserTest.assertTrue((String)"Created LogicExpression expression", (boolean)(andExpression instanceof LogicExpression));
            LogicExpression logicExpression = (LogicExpression)andExpression;
            Expression left = logicExpression.getLeft();
            Expression right = logicExpression.getRight();
            SelectorParserTest.assertTrue((String)"Left is a binary filter", (boolean)(left instanceof ComparisonExpression));
            SelectorParserTest.assertTrue((String)"Right is a binary filter", (boolean)(right instanceof ComparisonExpression));
            ComparisonExpression leftCompare = (ComparisonExpression)left;
            ComparisonExpression rightCompare = (ComparisonExpression)right;
            this.assertPropertyExpression("left", leftCompare.getLeft(), "x");
            this.assertPropertyExpression("right", rightCompare.getLeft(), "y");
        }
    }

    protected void assertPropertyExpression(String message, Expression expression, String expected) {
        SelectorParserTest.assertTrue((String)(message + ". Must be PropertyExpression"), (boolean)(expression instanceof PropertyExpression));
        PropertyExpression propExp = (PropertyExpression)expression;
        SelectorParserTest.assertEquals((String)(message + ". Property name"), (String)expected, (String)propExp.getName());
    }

    protected Filter parse(String text) throws Exception {
        return new SelectorParser().parse(text);
    }
}

