/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.security.jassjacc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.TestCase;
import org.activemq.security.jassjacc.BrokerSecurityConfig;
import org.activemq.security.jassjacc.DestinationSecurityConfig;
import org.activemq.security.jassjacc.PropertiesConfigLoader;

public class PropertiesConfigLoaderTest
extends TestCase {
    public void testConfigLoading() throws IOException {
        InputStream s = ((Object)((Object)this)).getClass().getResourceAsStream("security.properties");
        Properties p = new Properties();
        p.load(s);
        s.close();
        PropertiesConfigLoader loader = new PropertiesConfigLoader("localhost", p);
        BrokerSecurityConfig brokerConfig = loader.getBrokerSecurityConfig();
        PropertiesConfigLoaderTest.assertNotNull((Object)brokerConfig);
        PropertiesConfigLoaderTest.assertEquals((String)"localhost", (String)brokerConfig.getBrokerName());
        PropertiesConfigLoaderTest.assertTrue((boolean)brokerConfig.getConnectRoles().contains("admins"));
        PropertiesConfigLoaderTest.assertTrue((boolean)brokerConfig.getConnectRoles().contains("traders"));
        PropertiesConfigLoaderTest.assertTrue((boolean)brokerConfig.getConnectRoles().contains("brokers"));
        PropertiesConfigLoaderTest.assertTrue((boolean)brokerConfig.getConnectRoles().contains("guests"));
        DestinationSecurityConfig[] destinationSecurityConfigs = loader.getDestinationSecurityConfigs();
        PropertiesConfigLoaderTest.assertEquals((int)4, (int)destinationSecurityConfigs.length);
    }
}

