/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.perf;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.activemq.perf.PerfRate;

public class PerfProducer {
    protected Connection connection;
    protected MessageProducer producer;
    protected PerfRate rate = new PerfRate();

    public PerfProducer(ConnectionFactory fac, Destination dest) throws JMSException {
        this.connection = fac.createConnection();
        Session s = this.connection.createSession(false, 1);
        this.producer = s.createProducer(dest);
        this.producer.setDeliveryMode(1);
    }

    public void setDeliveryMode(int mode) throws JMSException {
        this.producer.setDeliveryMode(mode);
    }

    public void start() throws JMSException {
        this.connection.start();
        this.rate.getRate();
    }

    public void stop() throws JMSException {
        this.connection.stop();
    }

    public void shutDown() throws JMSException {
        this.connection.close();
    }

    public void sendMessage(Message msg) throws JMSException {
        this.producer.send(msg);
        this.rate.increment();
    }

    public PerfRate getRate() {
        return this.rate;
    }
}

