/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.io.impl.PacketReader;
import org.activemq.io.impl.PacketWriter;
import org.activemq.message.Packet;

public abstract class PacketTestSupport
extends TestCase {
    protected WireFormat wireFormat = new DefaultWireFormat();
    protected PacketWriter writer;
    protected PacketReader reader;
    protected int packetCount = 10;

    public void testWireFormat() throws IOException, JMSException {
        DefaultWireFormat wireFormat = new DefaultWireFormat();
        Packet packet = this.createPacket();
        System.out.println("Created packet: " + packet + " with type: " + packet.getPacketType());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(buffer);
        wireFormat.writePacket(packet, (DataOutput)dataOut);
        dataOut.close();
        byte[] bytes = buffer.toByteArray();
        DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(bytes));
        byte type = dataIn.readByte();
        System.out.println("Read type: " + type);
        Packet otherPacket = wireFormat.readPacket((int)type, (DataInput)dataIn);
        System.out.println("Read packet: " + otherPacket);
        this.assertPacket(otherPacket, packet);
    }

    public void testToFromBytes() throws JMSException, IOException {
        Packet packet = this.createPacket();
        byte[] data = this.wireFormat.toBytes(packet);
        System.out.println("Written byte array of size: " + data.length);
        Packet value = this.wireFormat.fromBytes(data);
        this.assertValidPacket(value);
    }

    public void testReadAndWriteDataInOut() throws JMSException, IOException {
        Packet packet = this.createPacket();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buffer);
        this.wireFormat.writePacket(packet, (DataOutput)out);
        out.close();
        byte[] data = buffer.toByteArray();
        System.out.println("Written byte array of size: " + data.length);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        Packet value = this.wireFormat.readPacket((DataInput)in);
        this.assertValidPacket(value);
    }

    public void testReadAndWriteDataInOutLoop() throws JMSException, IOException {
        Packet packet = this.createPacket();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buffer);
        for (int i = 0; i < this.packetCount; ++i) {
            this.wireFormat.writePacket(packet, (DataOutput)out);
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        for (int i = 0; i < this.packetCount; ++i) {
            Packet value = this.wireFormat.readPacket((DataInput)in);
            this.assertValidPacket(value);
        }
    }

    protected void assertPacket(Packet packet, Packet expected) {
        this.assertValidPacket(packet);
    }

    protected abstract Packet createPacket();

    protected abstract void assertValidPacket(Packet var1);
}

