/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.message.Packet;
import org.activemq.message.PacketFacade;
import org.activemq.message.ProducerInfo;
import org.activemq.message.TransactionInfo;

public class PackageFacadeTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Class)PackageFacadeTest.class);
    }

    public void testTransactionInfo() throws Exception {
        TransactionInfo info = new TransactionInfo();
        info.setId((short)544);
        TransactionInfo info2 = (TransactionInfo)this.writeAndReadPacket((Packet)info);
        PackageFacadeTest.assertEquals((String)"id", (short)info.getId(), (short)info2.getId());
    }

    public void testProducerInfo() throws Exception {
        ProducerInfo info = new ProducerInfo();
        info.setId((short)544);
        info.setClientId("SomeClientID");
        ProducerInfo info2 = (ProducerInfo)this.writeAndReadPacket((Packet)info);
        PackageFacadeTest.assertEquals((String)"id", (short)info.getId(), (short)info2.getId());
        PackageFacadeTest.assertEquals((String)"clientID", (String)info.getClientId(), (String)info2.getClientId());
    }

    protected Packet writeAndReadPacket(Packet info) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(new PacketFacade(info));
        out.close();
        byte[] bytes = buffer.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object value = in.readObject();
        in.close();
        PackageFacadeTest.assertTrue((String)("value is PacketFacade: " + value), (boolean)(value instanceof PacketFacade));
        PacketFacade facade = (PacketFacade)value;
        Packet packet = facade.getPacket();
        PackageFacadeTest.assertTrue((String)("Should have a non-null packet: " + packet), (packet != null ? 1 : 0) != 0);
        return packet;
    }
}

