/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import javax.jms.JMSException;
import javax.transaction.xa.Xid;
import junit.framework.TestCase;
import org.activemq.message.ActiveMQXid;

public class ActiveMQXidTest
extends TestCase {
    final byte[] branch = new byte[256];
    final byte[] global = new byte[256];
    final int format = 101;
    private Xid testXid;

    protected void setUp() throws Exception {
        int i;
        for (i = 0; i < this.branch.length; ++i) {
            this.branch[i] = (byte)i;
        }
        for (i = 0; i < this.global.length; ++i) {
            this.global[i] = (byte)i;
        }
        this.testXid = new Xid(){

            public byte[] getBranchQualifier() {
                return ActiveMQXidTest.this.branch;
            }

            public int getFormatId() {
                return 101;
            }

            public byte[] getGlobalTransactionId() {
                return ActiveMQXidTest.this.global;
            }
        };
    }

    public void testEncodeDecode() throws JMSException {
        ActiveMQXid xid1 = new ActiveMQXid(this.testXid);
        String localxid = xid1.toLocalTransactionId();
        System.out.println(localxid);
        ActiveMQXid xid2 = new ActiveMQXid(localxid);
        ActiveMQXidTest.assertTrue((boolean)localxid.equals(xid2.toLocalTransactionId()));
        ActiveMQXidTest.assertEquals((String)"CompareTo should match", (int)0, (int)xid1.compareTo((Object)xid2));
        ActiveMQXidTest.assertEquals((String)"equals should match", (Object)xid1, (Object)xid2);
        ActiveMQXidTest.assertTrue((xid2.getFormatId() == this.testXid.getFormatId() ? 1 : 0) != 0);
        this.assertSameBytes(xid2.getBranchQualifier(), this.testXid.getBranchQualifier());
        this.assertSameBytes(xid2.getGlobalTransactionId(), this.testXid.getGlobalTransactionId());
    }

    protected void assertSameBytes(byte[] bs, byte[] bs2) {
        ActiveMQXidTest.assertFalse((boolean)(bs == null ^ bs2 == null));
        if (bs == null) {
            return;
        }
        ActiveMQXidTest.assertTrue((bs.length == bs2.length ? 1 : 0) != 0);
        for (int i = 0; i < bs.length; ++i) {
            ActiveMQXidTest.assertTrue((bs[i] == bs2[i] ? 1 : 0) != 0);
        }
    }
}

