/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.io.IOException;
import javax.jms.JMSException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.Packet;

public class ActiveMQTextMessageTest
extends TestCase {
    private WireFormat wireFormat = new DefaultWireFormat();

    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQTextMessageTest.class);
    }

    public void testGetPacketType() {
        ActiveMQTextMessage msg = new ActiveMQTextMessage();
        ActiveMQTextMessageTest.assertTrue((msg.getPacketType() == 7 ? 1 : 0) != 0);
    }

    public void testSetText() {
        ActiveMQTextMessage msg = new ActiveMQTextMessage();
        String str = "testText";
        try {
            msg.setText(str);
            ActiveMQTextMessageTest.assertTrue((msg.getText() == str ? 1 : 0) != 0);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        boolean readOnlyTest = false;
        msg.setReadOnly(true);
        try {
            msg.setText(str);
        }
        catch (JMSException e) {
            readOnlyTest = true;
        }
        ActiveMQTextMessageTest.assertTrue((boolean)readOnlyTest);
    }

    public void testReadAndWriteMessage() throws JMSException, IOException {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setJMSMessageID("abc:123");
        message.setExternalMessageId(true);
        message.setText("Testing 1, 2, 3");
        byte[] data = this.wireFormat.toBytes((Packet)message);
        Packet packet = this.wireFormat.fromBytes(data);
        ActiveMQTextMessageTest.assertTrue((boolean)(packet instanceof ActiveMQTextMessage));
        ActiveMQTextMessage message2 = (ActiveMQTextMessage)packet;
        ActiveMQTextMessageTest.assertEquals((String)"Message IDs", (String)message.getJMSMessageID(), (String)message2.getJMSMessageID());
        ActiveMQTextMessageTest.assertEquals((String)"Message Text", (String)message.getText(), (String)message2.getText());
    }
}

