/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.io.IOException;
import javax.jms.JMSException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.message.ActiveMQStreamMessage;

public class ActiveMQStreamMessageTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQStreamMessageTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQStreamMessageTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        ActiveMQStreamMessageTest.assertTrue((msg.getPacketType() == 10 ? 1 : 0) != 0);
    }

    public void testShallowCopy() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        byte[] data = new byte[50];
        try {
            msg.setBodyAsBytes(data, 0, data.length);
            ActiveMQStreamMessage msg2 = (ActiveMQStreamMessage)msg.shallowCopy();
            ActiveMQStreamMessageTest.assertTrue((msg2.getBodyAsBytes() != null && msg2.getBodyAsBytes() == msg.getBodyAsBytes() ? 1 : 0) != 0);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testDeepCopy() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        byte[] data = new byte[50];
        msg.setBodyAsBytes(data, 0, data.length);
        try {
            ActiveMQStreamMessage msg2 = (ActiveMQStreamMessage)msg.deepCopy();
            ActiveMQStreamMessageTest.assertTrue((msg2.getBodyAsBytes() != null && msg2.getBodyAsBytes() != msg.getBodyAsBytes() && msg2.getBodyAsBytes().getLength() == data.length ? 1 : 0) != 0);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testSetData() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        byte[] data = new byte[50];
        msg.setBodyAsBytes(data, 0, data.length);
        try {
            ActiveMQStreamMessageTest.assertTrue((data == msg.getBodyAsBytes().getBuf() ? 1 : 0) != 0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadBoolean() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            msg.writeBoolean(true);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readBoolean());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals("true"));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testreadByte() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte test = 4;
            msg.writeByte(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readByte() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readShort() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readInt() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == (long)test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Byte(test).toString()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadShort() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            short test = 4;
            msg.writeShort(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readShort() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readInt() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == (long)test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Short(test).toString()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadChar() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            char test = 'z';
            msg.writeChar(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readChar() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Character(test).toString()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadInt() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            int test = 4;
            msg.writeInt(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readInt() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == (long)test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Integer(test).toString()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadLong() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            long test = 4L;
            msg.writeLong(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Long(test).toString()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadFloat() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            float test = 4.4f;
            msg.writeFloat(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readFloat() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readDouble() == (double)test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Float(test).toString()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadDouble() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            double test = 4.4;
            msg.writeDouble(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readDouble() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Double(test).toString()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadString() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte testByte = 2;
            msg.writeString(new Byte(testByte).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readByte() == testByte ? 1 : 0) != 0);
            msg.clearBody();
            short testShort = 3;
            msg.writeString(new Short(testShort).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readShort() == testShort ? 1 : 0) != 0);
            msg.clearBody();
            int testInt = 4;
            msg.writeString(new Integer(testInt).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readInt() == testInt ? 1 : 0) != 0);
            msg.clearBody();
            long testLong = 6L;
            msg.writeString(new Long(testLong).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == testLong ? 1 : 0) != 0);
            msg.clearBody();
            float testFloat = 6.6f;
            msg.writeString(new Float(testFloat).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readFloat() == testFloat ? 1 : 0) != 0);
            msg.clearBody();
            double testDouble = 7.7;
            msg.writeString(new Double(testDouble).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readDouble() == testDouble ? 1 : 0) != 0);
            msg.clearBody();
            msg.writeString("true");
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readBoolean());
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadBytes() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte[] test = new byte[50];
            for (int i = 0; i < test.length; ++i) {
                test[i] = (byte)i;
            }
            msg.writeBytes(test);
            msg.reset();
            byte[] valid = new byte[test.length];
            msg.readBytes(valid);
            for (int i = 0; i < valid.length; ++i) {
                ActiveMQStreamMessageTest.assertTrue((valid[i] == test[i] ? 1 : 0) != 0);
            }
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadObject() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte testByte = 2;
            msg.writeByte(testByte);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Byte)msg.readObject() == testByte ? 1 : 0) != 0);
            msg.clearBody();
            short testShort = 3;
            msg.writeShort(testShort);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Short)msg.readObject() == testShort ? 1 : 0) != 0);
            msg.clearBody();
            int testInt = 4;
            msg.writeInt(testInt);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Integer)msg.readObject() == testInt ? 1 : 0) != 0);
            msg.clearBody();
            long testLong = 6L;
            msg.writeLong(testLong);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Long)msg.readObject() == testLong ? 1 : 0) != 0);
            msg.clearBody();
            float testFloat = 6.6f;
            msg.writeFloat(testFloat);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((((Float)msg.readObject()).floatValue() == testFloat ? 1 : 0) != 0);
            msg.clearBody();
            double testDouble = 7.7;
            msg.writeDouble(testDouble);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Double)msg.readObject() == testDouble ? 1 : 0) != 0);
            msg.clearBody();
            char testChar = 'z';
            msg.writeChar(testChar);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((((Character)msg.readObject()).charValue() == testChar ? 1 : 0) != 0);
            msg.clearBody();
            byte[] data = new byte[50];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)i;
            }
            msg.writeBytes(data);
            msg.reset();
            byte[] valid = (byte[])msg.readObject();
            ActiveMQStreamMessageTest.assertTrue((valid.length == data.length ? 1 : 0) != 0);
            for (int i = 0; i < valid.length; ++i) {
                ActiveMQStreamMessageTest.assertTrue((valid[i] == data[i] ? 1 : 0) != 0);
            }
            msg.clearBody();
            msg.writeBoolean(true);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)((Boolean)msg.readObject()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }
}

