/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import junit.framework.TestCase;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQTemporaryTopic;
import org.activemq.message.ActiveMQTopic;

public class ActiveMQMessageTest
extends TestCase {
    private String jmsMessageID;
    private String jmsClientID;
    private String jmsCorrelationID;
    private ActiveMQDestination jmsDestination;
    private ActiveMQDestination jmsReplyTo;
    private int jmsDeliveryMode;
    private boolean jmsRedelivered;
    private String jmsType;
    private long jmsExpiration;
    private int jmsPriority;
    private long jmsTimestamp;
    private Map properties;
    protected boolean readOnlyMessage;
    private String entryBrokerName;
    private String entryClusterName;
    private int[] consumerIDs;

    public static void main(String[] args) {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jmsMessageID = "testid";
        this.jmsClientID = "testclientid";
        this.jmsCorrelationID = "testcorrelationid";
        this.jmsDestination = new ActiveMQTopic("test.topic");
        this.jmsReplyTo = new ActiveMQTemporaryTopic("test.replyto.topic");
        this.jmsDeliveryMode = 2;
        this.jmsRedelivered = true;
        this.jmsType = "test type";
        this.jmsExpiration = 100000L;
        this.jmsPriority = 5;
        this.jmsTimestamp = System.currentTimeMillis();
        this.properties = new HashMap();
        this.readOnlyMessage = false;
        this.entryBrokerName = "test broker";
        this.entryClusterName = "test cluster";
        this.consumerIDs = new int[3];
        for (int i = 0; i < this.consumerIDs.length; ++i) {
            this.consumerIDs[i] = i;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQMessageTest(String arg0) {
        super(arg0);
    }

    public void testHashCode() throws Exception {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessageTest.assertTrue((msg.hashCode() == this.jmsMessageID.hashCode() ? 1 : 0) != 0);
    }

    public void testGetPacketType() {
        ActiveMQMessage msg = new ActiveMQMessage();
        ActiveMQMessageTest.assertTrue((msg.getPacketType() == 6 ? 1 : 0) != 0);
    }

    public void testSetReadOnly() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setReadOnly(true);
        boolean test = false;
        try {
            msg.setIntProperty("test", 1);
        }
        catch (MessageNotWriteableException me) {
            test = true;
        }
        catch (JMSException e) {
            e.printStackTrace(System.err);
            test = false;
        }
        ActiveMQMessageTest.assertTrue((boolean)test);
    }

    public void testEqualsObject() {
        ActiveMQMessage msg1 = new ActiveMQMessage();
        ActiveMQMessage msg2 = new ActiveMQMessage();
        msg1.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessageTest.assertTrue((!msg1.equals((Object)msg2) ? 1 : 0) != 0);
        msg2.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessageTest.assertTrue((boolean)msg1.equals((Object)msg2));
    }

    public void testShallowCopy() throws Exception {
        ActiveMQMessage msg1 = new ActiveMQMessage();
        msg1.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessage msg2 = msg1.shallowCopy();
        ActiveMQMessageTest.assertTrue((msg1 != msg2 && msg1.equals((Object)msg2) ? 1 : 0) != 0);
    }

    public void testInitializeOther() {
        this.jmsMessageID = "testid";
        this.jmsClientID = "testclientid";
        this.jmsCorrelationID = "testcorrelationid";
        this.jmsDestination = new ActiveMQTopic("test.topic");
        this.jmsReplyTo = new ActiveMQTemporaryTopic("test.replyto.topic");
        this.jmsDeliveryMode = 2;
        this.jmsRedelivered = true;
        this.jmsType = "test type";
        this.jmsExpiration = 100000L;
        this.jmsPriority = 5;
        this.jmsTimestamp = System.currentTimeMillis();
        this.properties = new HashMap();
        this.readOnlyMessage = false;
        this.entryBrokerName = "test broker";
        this.entryClusterName = "test cluster";
        this.consumerIDs = new int[3];
        ActiveMQMessage msg1 = new ActiveMQMessage();
        msg1.setJMSMessageID(this.jmsMessageID);
        msg1.setJMSClientID(this.jmsClientID);
        msg1.setJMSCorrelationID(this.jmsCorrelationID);
        msg1.setJMSDestination((Destination)this.jmsDestination);
        msg1.setJMSReplyTo((Destination)this.jmsReplyTo);
        msg1.setJMSDeliveryMode(this.jmsDeliveryMode);
        msg1.setJMSRedelivered(this.jmsRedelivered);
        msg1.setJMSType(this.jmsType);
        msg1.setJMSExpiration(this.jmsExpiration);
        msg1.setJMSPriority(this.jmsPriority);
        msg1.setJMSTimestamp(this.jmsTimestamp);
        msg1.setProperties(this.properties);
        msg1.setReadOnly(true);
        msg1.setEntryBrokerName(this.entryBrokerName);
        msg1.setEntryClusterName(this.entryClusterName);
        msg1.setConsumerNos(this.consumerIDs);
        ActiveMQMessage msg2 = new ActiveMQMessage();
        msg1.initializeOther(msg2);
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSMessageID().equals(msg2.getJMSMessageID()));
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSClientID().equals(msg2.getJMSClientID()));
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSCorrelationID().equals(msg2.getJMSCorrelationID()));
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSDestination().equals(msg2.getJMSDestination()));
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSReplyTo().equals(msg2.getJMSReplyTo()));
        ActiveMQMessageTest.assertTrue((msg1.getJMSDeliveryMode() == msg2.getJMSDeliveryMode() ? 1 : 0) != 0);
        ActiveMQMessageTest.assertTrue((msg1.getJMSRedelivered() == msg2.getJMSRedelivered() ? 1 : 0) != 0);
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSType().equals(msg2.getJMSType()));
        ActiveMQMessageTest.assertTrue((msg1.getJMSExpiration() == msg2.getJMSExpiration() ? 1 : 0) != 0);
        ActiveMQMessageTest.assertTrue((msg1.getJMSPriority() == msg2.getJMSPriority() ? 1 : 0) != 0);
        ActiveMQMessageTest.assertTrue((msg1.getJMSTimestamp() == msg2.getJMSTimestamp() ? 1 : 0) != 0);
        ActiveMQMessageTest.assertTrue((boolean)((Object)msg1.getProperties()).equals(msg2.getProperties()));
        ActiveMQMessageTest.assertTrue((boolean)msg1.getEntryBrokerName().equals(msg2.getEntryBrokerName()));
        ActiveMQMessageTest.assertTrue((boolean)msg1.getEntryClusterName().equals(msg2.getEntryClusterName()));
        ActiveMQMessageTest.assertTrue((boolean)msg1.getConsumerNos().equals(msg2.getConsumerNos()));
    }

    public void testGetJMSMessageID() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessageTest.assertTrue((msg.getJMSMessageID() == this.jmsMessageID ? 1 : 0) != 0);
    }

    public void testSetJMSMessageID() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessageTest.assertTrue((msg.getJMSMessageID() == this.jmsMessageID ? 1 : 0) != 0);
    }

    public void testGetJMSTimestamp() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSTimestamp(this.jmsTimestamp);
        ActiveMQMessageTest.assertTrue((msg.getJMSTimestamp() == this.jmsTimestamp ? 1 : 0) != 0);
    }

    public void testSetJMSTimestamp() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSTimestamp(this.jmsTimestamp);
        ActiveMQMessageTest.assertTrue((msg.getJMSTimestamp() == this.jmsTimestamp ? 1 : 0) != 0);
    }

    public void testGetJMSCorrelationIDAsBytes() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSCorrelationID(this.jmsCorrelationID);
        byte[] testbytes = msg.getJMSCorrelationIDAsBytes();
        String str2 = new String(testbytes);
        ActiveMQMessageTest.assertTrue((boolean)this.jmsCorrelationID.equals(str2));
    }

    public void testSetJMSCorrelationIDAsBytes() {
        ActiveMQMessage msg = new ActiveMQMessage();
        byte[] testbytes = this.jmsCorrelationID.getBytes();
        msg.setJMSCorrelationIDAsBytes(testbytes);
        testbytes = msg.getJMSCorrelationIDAsBytes();
        String str2 = new String(testbytes);
        ActiveMQMessageTest.assertTrue((boolean)this.jmsCorrelationID.equals(str2));
    }

    public void testSetJMSCorrelationID() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSCorrelationID(this.jmsCorrelationID);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSCorrelationID().equals(this.jmsCorrelationID));
    }

    public void testGetJMSCorrelationID() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSCorrelationID(this.jmsCorrelationID);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSCorrelationID().equals(this.jmsCorrelationID));
    }

    public void testGetJMSReplyTo() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSReplyTo((Destination)this.jmsReplyTo);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSReplyTo().equals(this.jmsReplyTo));
    }

    public void testSetJMSReplyTo() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSReplyTo((Destination)this.jmsReplyTo);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSReplyTo().equals(this.jmsReplyTo));
    }

    public void testGetJMSDestination() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSDestination((Destination)this.jmsDestination);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSDestination().equals(this.jmsDestination));
    }

    public void testSetJMSDestination() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSDestination((Destination)this.jmsDestination);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSDestination().equals(this.jmsDestination));
    }

    public void testGetJMSDeliveryMode() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSDeliveryMode(this.jmsDeliveryMode);
        ActiveMQMessageTest.assertTrue((msg.getJMSDeliveryMode() == this.jmsDeliveryMode ? 1 : 0) != 0);
    }

    public void testSetJMSDeliveryMode() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSDeliveryMode(this.jmsDeliveryMode);
        ActiveMQMessageTest.assertTrue((msg.getJMSDeliveryMode() == this.jmsDeliveryMode ? 1 : 0) != 0);
    }

    public void testGetJMSRedelivered() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSRedelivered(this.jmsRedelivered);
        ActiveMQMessageTest.assertTrue((msg.getJMSRedelivered() == this.jmsRedelivered ? 1 : 0) != 0);
    }

    public void testSetJMSRedelivered() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSRedelivered(this.jmsRedelivered);
        ActiveMQMessageTest.assertTrue((msg.getJMSRedelivered() == this.jmsRedelivered ? 1 : 0) != 0);
    }

    public void testGetJMSType() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSType(this.jmsType);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSType().equals(this.jmsType));
    }

    public void testSetJMSType() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSType(this.jmsType);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSType().equals(this.jmsType));
    }

    public void testGetJMSExpiration() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSExpiration(this.jmsExpiration);
        ActiveMQMessageTest.assertTrue((msg.getJMSExpiration() == this.jmsExpiration ? 1 : 0) != 0);
    }

    public void testSetJMSExpiration() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSExpiration(this.jmsExpiration);
        ActiveMQMessageTest.assertTrue((msg.getJMSExpiration() == this.jmsExpiration ? 1 : 0) != 0);
    }

    public void testGetJMSPriority() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSPriority(this.jmsPriority);
        ActiveMQMessageTest.assertTrue((msg.getJMSPriority() == this.jmsPriority ? 1 : 0) != 0);
    }

    public void testSetJMSPriority() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSPriority(this.jmsPriority);
        ActiveMQMessageTest.assertTrue((msg.getJMSPriority() == this.jmsPriority ? 1 : 0) != 0);
    }

    public void testClearProperties() {
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("test", new Integer(1));
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setProperties(props);
        msg.clearProperties();
        ActiveMQMessageTest.assertTrue((props.size() == 0 ? 1 : 0) != 0);
    }

    public void testPropertyExists() {
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("test", new Integer(1));
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setProperties(props);
        msg.clearProperties();
        ActiveMQMessageTest.assertTrue((props.size() == 0 ? 1 : 0) != 0);
    }

    public void testGetBooleanProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "booleanProperty";
        msg.setBooleanProperty(name, true);
        ActiveMQMessageTest.assertTrue((boolean)msg.getBooleanProperty(name));
    }

    public void testGetByteProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "byteProperty";
        msg.setByteProperty(name, (byte)1);
        ActiveMQMessageTest.assertTrue((msg.getByteProperty(name) == 1 ? 1 : 0) != 0);
    }

    public void testGetShortProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "shortProperty";
        msg.setShortProperty(name, (short)1);
        ActiveMQMessageTest.assertTrue((msg.getShortProperty(name) == 1 ? 1 : 0) != 0);
    }

    public void testGetIntProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "intProperty";
        msg.setIntProperty(name, 1);
        ActiveMQMessageTest.assertTrue((msg.getIntProperty(name) == 1 ? 1 : 0) != 0);
    }

    public void testGetLongProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "longProperty";
        msg.setLongProperty(name, 1L);
        ActiveMQMessageTest.assertTrue((msg.getLongProperty(name) == 1L ? 1 : 0) != 0);
    }

    public void testGetFloatProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "floatProperty";
        msg.setFloatProperty(name, 1.3f);
        ActiveMQMessageTest.assertTrue((msg.getFloatProperty(name) == 1.3f ? 1 : 0) != 0);
    }

    public void testGetDoubleProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "doubleProperty";
        msg.setDoubleProperty(name, 1.3);
        ActiveMQMessageTest.assertTrue((msg.getDoubleProperty(name) == 1.3 ? 1 : 0) != 0);
    }

    public void testGetStringProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "stringProperty";
        msg.setStringProperty(name, name);
        ActiveMQMessageTest.assertTrue((boolean)msg.getStringProperty(name).equals(name));
    }

    public void testGetObjectProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "floatProperty";
        msg.setFloatProperty(name, 1.3f);
        ActiveMQMessageTest.assertTrue((boolean)(msg.getObjectProperty(name) instanceof Float));
        ActiveMQMessageTest.assertTrue((((Float)msg.getObjectProperty(name)).floatValue() == 1.3f ? 1 : 0) != 0);
    }

    public void testGetPropertyNames() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "floatProperty";
        msg.setFloatProperty(name, 1.3f);
        Enumeration iter = msg.getPropertyNames();
        while (iter.hasMoreElements()) {
            ActiveMQMessageTest.assertTrue((boolean)iter.nextElement().equals(name));
        }
    }

    public void testGetProperties() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "floatProperty";
        msg.setFloatProperty(name, 1.3f);
        Map props = msg.getProperties();
        ActiveMQMessageTest.assertTrue((boolean)(props.get(name) instanceof Float));
        ActiveMQMessageTest.assertTrue((((Float)props.get(name)).floatValue() == 1.3f ? 1 : 0) != 0);
    }

    public void testSetObjectProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "floatProperty";
        msg.setFloatProperty(name, 1.3f);
        Map props = msg.getProperties();
        ActiveMQMessageTest.assertTrue((boolean)(props.get(name) instanceof Float));
        ActiveMQMessageTest.assertTrue((((Float)props.get(name)).floatValue() == 1.3f ? 1 : 0) != 0);
    }

    public void testSetNullProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "cheese";
        msg.setStringProperty(name, "Cheddar");
        ActiveMQMessageTest.assertEquals((String)"Cheddar", (String)msg.getStringProperty(name));
        msg.setStringProperty(name, null);
        ActiveMQMessageTest.assertEquals(null, (String)msg.getStringProperty(name));
    }

    public void testSetNullPropertyName() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        try {
            msg.setStringProperty(null, "Cheese");
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Worked, caught: " + e);
        }
    }

    public void testSetEmptyPropertyName() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        try {
            msg.setStringProperty("", "Cheese");
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Worked, caught: " + e);
        }
    }

    public void testGetJMSXDeliveryCount() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        int count = msg.getIntProperty("JMSXDeliveryCount");
        ActiveMQMessageTest.assertTrue((String)("expected delivery count = 1 - got: " + count), (count == 1 ? 1 : 0) != 0);
    }

    public void testAcknowledge() {
    }

    public void testClearBody() {
    }

    public void testGetEntryBrokerName() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setEntryBrokerName(this.entryBrokerName);
        ActiveMQMessageTest.assertTrue((msg.getEntryBrokerName() == this.entryBrokerName ? 1 : 0) != 0);
    }

    public void testGetEntryClusterName() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setEntryClusterName(this.entryClusterName);
        ActiveMQMessageTest.assertTrue((msg.getEntryClusterName() == this.entryClusterName ? 1 : 0) != 0);
    }

    public void testGetConsumerIDs() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setConsumerNos(this.consumerIDs);
        ActiveMQMessageTest.assertTrue((msg.getConsumerNos() == this.consumerIDs ? 1 : 0) != 0);
    }
}

