/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.util.HashMap;
import javax.jms.JMSException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.message.ActiveMQMapMessage;

public class ActiveMQMapMessageTest
extends TestCase {
    private String name = "testName";

    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQMapMessageTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQMapMessageTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        ActiveMQMapMessageTest.assertTrue((msg.getPacketType() == 11 ? 1 : 0) != 0);
    }

    public void testShallowCopy() {
        try {
            ActiveMQMapMessage msg = new ActiveMQMapMessage();
            msg.setString("fred", "fred");
            ActiveMQMapMessage msg2 = (ActiveMQMapMessage)msg.shallowCopy();
            ActiveMQMapMessageTest.assertTrue((msg2.getTable() != null && msg2.getTable() == msg.getTable() ? 1 : 0) != 0);
        }
        catch (JMSException e) {
            e.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testDeepCopy() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            ActiveMQMapMessage msg2 = (ActiveMQMapMessage)msg.deepCopy();
            ActiveMQMapMessageTest.assertTrue((msg2.getTable() != null && msg2.getTable() != msg.getTable() ? 1 : 0) != 0);
        }
        catch (JMSException e) {
            e.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testSetTable() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        HashMap table = new HashMap();
        msg.setTable(table);
        try {
            ActiveMQMapMessageTest.assertTrue((msg.getTable() == table ? 1 : 0) != 0);
        }
        catch (JMSException e) {
            e.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetBoolean() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            msg.setBoolean(this.name, true);
            msg.setReadOnly(true);
            ActiveMQMapMessageTest.assertTrue((boolean)msg.getBoolean(this.name));
            msg.clearBody();
            msg.setString(this.name, "true");
            ActiveMQMapMessageTest.assertTrue((boolean)msg.getBoolean(this.name));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetByte() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            msg.setByte(this.name, (byte)1);
            msg.setReadOnly(true);
            ActiveMQMapMessageTest.assertTrue((msg.getByte(this.name) == 1 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetShort() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            msg.setByte(this.name, (byte)1);
            msg.setReadOnly(true);
            ActiveMQMapMessageTest.assertTrue((msg.getByte(this.name) == 1 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetChar() {
    }

    public void testGetInt() {
    }

    public void testGetLong() {
    }

    public void testGetFloat() {
    }

    public void testGetDouble() {
    }

    public void testGetString() {
    }

    public void testGetBytes() {
    }

    public void testGetObject() {
    }

    public void testGetMapNames() {
    }

    public void testSetBoolean() {
    }

    public void testSetByte() {
    }

    public void testSetShort() {
    }

    public void testSetChar() {
    }

    public void testSetInt() {
    }

    public void testSetLong() {
    }

    public void testSetFloat() {
    }

    public void testSetDouble() {
    }

    public void testSetString() {
    }

    public void testSetBytesStringbyteArray() {
    }

    public void testSetBytesStringbyteArrayintint() {
    }

    public void testSetObject() {
    }

    public void testItemExists() {
    }
}

