/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTemporaryTopic;
import org.activemq.message.ActiveMQTopic;

public class ActiveMQDestinationTest
extends TestCase {
    ActiveMQDestination topic1 = new ActiveMQTopic("FOO.BAR");
    ActiveMQDestination topic2 = new ActiveMQTopic("FOO.XXX");
    ActiveMQDestination topic3 = new ActiveMQTopic("FOO.BAR");
    ActiveMQDestination topic4 = new ActiveMQTopic(null);
    ActiveMQDestination queue1 = new ActiveMQQueue("FOO.BAR");
    ActiveMQDestination queue2 = new ActiveMQQueue("FOO.XXX");
    ActiveMQDestination queue3 = new ActiveMQQueue("FOO.BAR");
    ActiveMQDestination queue4 = new ActiveMQQueue(null);

    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQDestinationTest.class);
    }

    public void testCompareTopics() {
        this.assertCompareTo(this.topic1, this.topic2, -1);
        this.assertCompareTo(this.topic2, this.topic1, 1);
        this.assertCompareTo(this.topic1, this.topic3, 0);
        this.assertCompareTo(this.topic4, this.topic1, -1);
        this.assertCompareTo(this.topic1, this.topic4, 1);
    }

    public void testCompareQueues() {
        this.assertCompareTo(this.queue1, this.queue2, -1);
        this.assertCompareTo(this.queue2, this.queue1, 1);
        this.assertCompareTo(this.queue1, this.queue3, 0);
        this.assertCompareTo(this.queue4, this.queue1, -1);
        this.assertCompareTo(this.queue1, this.queue4, 1);
    }

    public void testCompareQueuesAndTopics() {
        this.assertCompareTo(this.topic1, this.queue1, 1);
        this.assertCompareTo(this.queue1, this.topic1, -1);
        this.assertCompareTo(this.topic1, this.queue2, -1);
        this.assertCompareTo(this.queue2, this.topic1, 1);
    }

    public void testGetClientID() {
        String clientID = "TestClientId";
        String temp = ActiveMQDestination.createTemporaryName((String)clientID);
        ActiveMQTemporaryTopic tempDest = new ActiveMQTemporaryTopic(temp);
        ActiveMQDestinationTest.assertTrue((boolean)ActiveMQDestination.getClientId((ActiveMQDestination)tempDest).equals(clientID));
    }

    public void testCompositeQueues() {
        ActiveMQQueue destination = new ActiveMQQueue("FOO.BAR,COM.ACME.WHATNOT,FOO.>");
        ActiveMQDestinationTest.assertTrue((boolean)destination.isComposite());
        List destinations = destination.getChildDestinations();
        ActiveMQDestinationTest.assertEquals((String)"Size is wrong", (int)3, (int)destinations.size());
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQQueue("FOO.BAR"), destinations.get(0));
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQQueue("COM.ACME.WHATNOT"), destinations.get(1));
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQQueue("FOO.>"), destinations.get(2));
    }

    public void testCompositeQueueWithChildTopic() {
        ActiveMQQueue destination = new ActiveMQQueue("FOO.BAR,topic://COM.ACME.WHATNOT,FOO.>");
        ActiveMQDestinationTest.assertTrue((boolean)destination.isComposite());
        List destinations = destination.getChildDestinations();
        ActiveMQDestinationTest.assertEquals((String)"Size is wrong", (int)3, (int)destinations.size());
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQQueue("FOO.BAR"), destinations.get(0));
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQTopic("COM.ACME.WHATNOT"), destinations.get(1));
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQQueue("FOO.>"), destinations.get(2));
    }

    public void testCompositeTopics() {
        ActiveMQTopic destination = new ActiveMQTopic("FOO.BAR,COM.ACME.WHATNOT,FOO.>");
        ActiveMQDestinationTest.assertTrue((boolean)destination.isComposite());
        List destinations = destination.getChildDestinations();
        ActiveMQDestinationTest.assertEquals((String)"Size is wrong", (int)3, (int)destinations.size());
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQTopic("FOO.BAR"), destinations.get(0));
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQTopic("COM.ACME.WHATNOT"), destinations.get(1));
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQTopic("FOO.>"), destinations.get(2));
    }

    public void testCompositeTopicsWithChildQueue() {
        ActiveMQTopic destination = new ActiveMQTopic("queue://FOO.BAR,COM.ACME.WHATNOT,queue://FOO.>");
        ActiveMQDestinationTest.assertTrue((boolean)destination.isComposite());
        List destinations = destination.getChildDestinations();
        ActiveMQDestinationTest.assertEquals((String)"Size is wrong", (int)3, (int)destinations.size());
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQQueue("FOO.BAR"), destinations.get(0));
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQTopic("COM.ACME.WHATNOT"), destinations.get(1));
        ActiveMQDestinationTest.assertEquals((Object)new ActiveMQQueue("FOO.>"), destinations.get(2));
    }

    public void testNormalDestinationsAreNotComposite() {
        ActiveMQQueue destination = new ActiveMQQueue("FOO");
        ActiveMQDestinationTest.assertTrue((!destination.isComposite() ? 1 : 0) != 0);
        destination = new ActiveMQTopic("FOO");
        ActiveMQDestinationTest.assertTrue((!destination.isComposite() ? 1 : 0) != 0);
        System.out.println("Composite queues: " + destination.getChildDestinations());
    }

    public void testAdvisoryDestination() {
        String name = "foo.bar";
        ActiveMQTopic destination = new ActiveMQTopic(name);
        ActiveMQTopic advisory = destination.getTopicForConsumerAdvisory();
        ActiveMQDestinationTest.assertTrue((boolean)advisory.isAdvisory());
    }

    protected void assertCompareTo(ActiveMQDestination dest1, ActiveMQDestination dest2, int expected) {
        int value = dest1.compareTo(dest2);
        String message = "Comparsing: " + dest1 + " to: " + dest2 + " found value: " + value + " expected: " + expected;
        String hashCodeMessage = "HashCode for: " + dest1 + " is " + dest1.hashCode() + " for: " + dest2 + " is " + dest2.hashCode();
        switch (expected) {
            case 0: {
                ActiveMQDestinationTest.assertEquals((String)message, (int)0, (int)value);
                ActiveMQDestinationTest.assertEquals((String)hashCodeMessage, (int)dest1.hashCode(), (int)dest2.hashCode());
                break;
            }
            case 1: {
                ActiveMQDestinationTest.assertTrue((String)message, (value > 0 ? 1 : 0) != 0);
                ActiveMQDestinationTest.assertTrue((String)hashCodeMessage, (dest1.hashCode() != dest2.hashCode() ? 1 : 0) != 0);
                break;
            }
            default: {
                ActiveMQDestinationTest.assertTrue((String)message, (value < 0 ? 1 : 0) != 0);
                ActiveMQDestinationTest.assertTrue((String)hashCodeMessage, (dest1.hashCode() != dest2.hashCode() ? 1 : 0) != 0);
            }
        }
    }
}

