/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.message.ActiveMQBytesMessage;

public class ActiveMQBytesMessageTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQBytesMessageTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQBytesMessageTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        ActiveMQBytesMessageTest.assertTrue((msg.getPacketType() == 9 ? 1 : 0) != 0);
    }

    public void testShallowCopy() throws Exception {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        byte[] data = new byte[50];
        msg.setBodyAsBytes(data, 0, data.length);
        ActiveMQBytesMessage msg2 = (ActiveMQBytesMessage)msg.shallowCopy();
        try {
            ActiveMQBytesMessageTest.assertTrue((msg2.getBodyAsBytes() != null && msg2.getBodyAsBytes() == msg.getBodyAsBytes() ? 1 : 0) != 0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testDeepCopy() throws Exception {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        byte[] data = new byte[50];
        msg.setBodyAsBytes(data, 0, data.length);
        ActiveMQBytesMessage msg2 = (ActiveMQBytesMessage)msg.deepCopy();
        try {
            ActiveMQBytesMessageTest.assertTrue((msg2.getBodyAsBytes() != null && msg2.getBodyAsBytes() != msg.getBodyAsBytes() && msg2.getBodyAsBytes().getLength() == data.length ? 1 : 0) != 0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testSetData() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        byte[] data = new byte[50];
        msg.setBodyAsBytes(data, 0, data.length);
        try {
            ActiveMQBytesMessageTest.assertTrue((data == msg.getBodyAsBytes().getBuf() ? 1 : 0) != 0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetBodyLength() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        int len = 10;
        try {
            for (int i = 0; i < len; ++i) {
                msg.writeLong(5L);
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        try {
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.getBodyLength() == (long)(len * 8) ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadBoolean() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeBoolean(true);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((boolean)msg.readBoolean());
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadByte() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeByte((byte)2);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readByte() == 2 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadUnsignedByte() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeByte((byte)2);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readUnsignedByte() == 2 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadShort() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeShort((short)3000);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readShort() == 3000 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadUnsignedShort() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeShort((short)3000);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readUnsignedShort() == 3000 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadChar() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeChar('a');
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readChar() == 'a' ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadInt() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeInt(3000);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readInt() == 3000 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadLong() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeLong(3000L);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readLong() == 3000L ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadFloat() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeFloat(3.3f);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readFloat() == 3.3f ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadDouble() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeDouble(3.3);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readDouble() == 3.3 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadUTF() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            String str = "this is a test";
            msg.writeUTF(str);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((boolean)msg.readUTF().equals(str));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadBytesbyteArray() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            byte[] data = new byte[50];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)i;
            }
            msg.writeBytes(data);
            msg.reset();
            byte[] test = new byte[data.length];
            msg.readBytes(test);
            for (int i = 0; i < test.length; ++i) {
                ActiveMQBytesMessageTest.assertTrue((test[i] == i ? 1 : 0) != 0);
            }
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testWriteObject() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeObject((Object)new Boolean(true));
            msg.writeObject((Object)new Long(300L));
            msg.writeObject((Object)new Float(3.3f));
            msg.writeObject((Object)new Character('q'));
            msg.writeObject((Object)new Byte(1));
            msg.writeObject((Object)new Short(3));
            msg.writeObject((Object)new String("fred"));
            try {
                msg.writeObject(new Object());
                ActiveMQBytesMessageTest.assertTrue((boolean)false);
            }
            catch (MessageFormatException mfe) {
                ActiveMQBytesMessageTest.assertTrue((boolean)true);
            }
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }
}

