/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.jndi;

import java.util.Properties;
import javax.naming.InitialContext;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;

public class InitialContextTest
extends TestCase {
    public void testInitialContext() throws Exception {
        InitialContext context = new InitialContext();
        InitialContextTest.assertTrue((String)"Created context", (context != null ? 1 : 0) != 0);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)context.lookup("ConnectionFactory");
        InitialContextTest.assertTrue((String)"Should have created a ConnectionFactory", (connectionFactory != null ? 1 : 0) != 0);
        System.out.println("Created with brokerURL: " + connectionFactory.getBrokerURL());
    }

    public void testUsingStandardJNDIKeys() throws Exception {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "org.activemq.jndi.ActiveMQInitialContextFactory");
        String expected = "tcp://localhost:65432";
        properties.put("java.naming.provider.url", expected);
        InitialContext context = new InitialContext(properties);
        InitialContextTest.assertTrue((String)"Created context", (context != null ? 1 : 0) != 0);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)context.lookup("ConnectionFactory");
        InitialContextTest.assertTrue((String)"Should have created a ConnectionFactory", (connectionFactory != null ? 1 : 0) != 0);
        InitialContextTest.assertEquals((String)"the brokerURL should match", (String)expected, (String)connectionFactory.getBrokerURL());
    }
}

