/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.jndi;

import java.io.File;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;

public class AdminObjectTest
extends TestCase {
    Context fsContext;

    protected void setUp() {
        try {
            File tempDir = File.createTempFile("fsjndi", ".dir");
            tempDir.delete();
            tempDir = tempDir.getCanonicalFile();
            tempDir.mkdirs();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.fscontext.RefFSContextFactory");
            env.put("java.naming.provider.url", tempDir.toURL().toExternalForm());
            this.fsContext = new InitialContext(env);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        if (this.fsContext != null) {
            this.fsContext.close();
        }
    }

    public void testConnectionFactory() throws NamingException, Exception {
        if (this.fsContext == null) {
            return;
        }
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
        this.fsContext.rebind("ConnectionFactory", (Object)cf);
        Object lookup = this.fsContext.lookup("ConnectionFactory");
        AdminObjectTest.assertTrue((lookup != null ? 1 : 0) != 0);
        AdminObjectTest.assertTrue((boolean)(lookup instanceof ActiveMQConnectionFactory));
    }
}

