/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.jndi;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.activemq.jndi.JNDITestSupport;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTopic;

public class ActiveMQInitialContextFactoryTest
extends JNDITestSupport {
    public void testConnectionFactoriesArePresent() throws NamingException {
        String lookupName = this.getConnectionFactoryLookupName();
        this.assertConnectionFactoryPresent(lookupName);
    }

    public void testDestinationsArePresent() throws NamingException {
        Object destinations = this.context.lookup("destinations");
        ActiveMQInitialContextFactoryTest.assertTrue((String)("Should have created a destinations context but got: " + destinations), (boolean)(destinations instanceof Context));
        Context destContext = (Context)destinations;
        NamingEnumeration<Binding> iter = destContext.listBindings("");
        while (iter.hasMore()) {
            Binding binding = iter.next();
            System.out.println("Found key: " + binding.getName());
            this.assertBinding(binding);
        }
    }

    public void testDynamicallyGrowing() throws Exception {
        Object answer = this.context.lookup("dynamicQueues/FOO.BAR");
        ActiveMQInitialContextFactoryTest.assertTrue((String)("Should have found a queue but found: " + answer), (boolean)(answer instanceof ActiveMQQueue));
        ActiveMQQueue queue = (ActiveMQQueue)answer;
        ActiveMQInitialContextFactoryTest.assertEquals((String)"queue name", (String)"FOO.BAR", (String)queue.getPhysicalName());
        answer = this.context.lookup("dynamicTopics/A.B.C");
        ActiveMQInitialContextFactoryTest.assertTrue((String)("Should have found a topic but found: " + answer), (boolean)(answer instanceof ActiveMQTopic));
        ActiveMQTopic topic = (ActiveMQTopic)answer;
        ActiveMQInitialContextFactoryTest.assertEquals((String)"topic name", (String)"A.B.C", (String)topic.getPhysicalName());
    }

    protected String getConnectionFactoryLookupName() {
        return "ConnectionFactory";
    }
}

