/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.activemq.io.util.MemoryBoundedObjectManager;
import org.activemq.io.util.MemoryBoundedQueue;
import org.activemq.io.util.MemoryBoundedQueueManager;
import org.activemq.io.util.MemoryManageable;
import org.activemq.message.ActiveMQMessage;

public class MemoryBoundedQueueTest
extends TestCase {
    protected static final int TEST_INSTANCE_SIZE = 2048;
    private static final int TEST_ENQUEUE_SIZE = 1024;
    protected static final String QUEUE_NAME = "TestQueue";
    private final int TOTAL_LOAD = 100000;
    private final int NUMBER_CONSUMERS = 20;
    private Semaphore stoppedSemaphore = new Semaphore(-19L);
    private MemoryBoundedObjectManager memoryManager;
    private MemoryBoundedQueueManager queueManager;
    protected boolean supportJMSPriority = false;

    protected MemoryBoundedObjectManager getMemoryManager() {
        if (this.memoryManager == null) {
            this.memoryManager = new MemoryBoundedObjectManager("testmanager", 0x100000L, this.supportJMSPriority);
        }
        return this.memoryManager;
    }

    protected MemoryBoundedQueueManager getQueueManager() {
        if (this.queueManager == null) {
            this.queueManager = new MemoryBoundedQueueManager(this.getMemoryManager());
        }
        return this.queueManager;
    }

    public void testLoad() throws Exception {
        int i;
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        this.getMemoryManager().setValueLimit(40960L);
        ArrayList<Dequeue> list = new ArrayList<Dequeue>(20);
        int numberOfMessages = 5000;
        for (i = 0; i < 20; ++i) {
            Dequeue dq = new Dequeue(queue, i, numberOfMessages);
            list.add(dq);
            Thread t = new Thread(dq);
            t.setPriority(4);
            t.start();
        }
        for (i = 0; i < 100000; ++i) {
            ActiveMQMessage msg = new ActiveMQMessage();
            msg.setMemoryUsage(2048);
            queue.enqueue((MemoryManageable)msg);
        }
        try {
            MemoryBoundedQueueTest.assertTrue((boolean)this.stoppedSemaphore.attempt(30000L));
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        MemoryBoundedQueueTest.assertEquals((long)0L, (long)this.getMemoryManager().getTotalMemoryUsedSize());
        queue.close();
    }

    public void testClear() {
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        this.getMemoryManager().setValueLimit(2048L);
        ActiveMQMessage msg = new ActiveMQMessage();
        queue.enqueue((MemoryManageable)msg);
        queue.clear();
        MemoryBoundedQueueTest.assertTrue((queue.size() == 0 ? 1 : 0) != 0);
        queue.close();
    }

    public void testDequeue() throws Exception {
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        this.getMemoryManager().setValueLimit(204800L);
        ActiveMQMessage msg = new ActiveMQMessage();
        queue.enqueue((MemoryManageable)msg);
        MemoryManageable result = queue.dequeue();
        MemoryBoundedQueueTest.assertTrue((result == msg ? 1 : 0) != 0);
        queue.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClose() {
        final MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        this.getMemoryManager().setValueLimit(1024L);
        final SynchronizedBoolean success = new SynchronizedBoolean(false);
        MemoryBoundedQueue q1 = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        MemoryBoundedQueueTest.assertTrue((queue == q1 ? 1 : 0) != 0);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Thread.sleep(250L);
                    queue.dequeue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SynchronizedBoolean synchronizedBoolean = success;
                synchronized (synchronizedBoolean) {
                    success.set(true);
                    success.notify();
                }
            }
        });
        t.start();
        queue.close();
        try {
            SynchronizedBoolean synchronizedBoolean = success;
            synchronized (synchronizedBoolean) {
                if (!success.get()) {
                    success.wait(2000L);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        MemoryBoundedQueueTest.assertTrue((boolean)success.get());
        MemoryBoundedQueue q2 = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        MemoryBoundedQueueTest.assertTrue((queue != q2 ? 1 : 0) != 0);
    }

    public void testDequeueNoWait() throws Exception {
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        MemoryManageable obj = queue.dequeueNoWait();
        MemoryBoundedQueueTest.assertTrue((obj == null ? 1 : 0) != 0);
        queue.close();
    }

    public void testEnqueueFirst() throws Exception {
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        MemoryBoundedQueueTest.assertTrue((this.getMemoryManager().getTotalMemoryUsedSize() == 0L ? 1 : 0) != 0);
        Object mutex = new Object();
        this.getMemoryManager().setValueLimit(204800L);
        for (int i = 0; i < 10; ++i) {
            queue.enqueue((MemoryManageable)new ActiveMQMessage());
        }
        ActiveMQMessage test = new ActiveMQMessage();
        test.setJMSMessageID("FIRST");
        queue.enqueueFirst((MemoryManageable)test);
        MemoryManageable obj = queue.dequeue();
        MemoryBoundedQueueTest.assertTrue((obj == test ? 1 : 0) != 0);
        queue.close();
    }

    public void testEnqueueNoBlock() {
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        this.getMemoryManager().setValueLimit(1024L);
        ActiveMQMessage msg = new ActiveMQMessage();
        queue.enqueueNoBlock((MemoryManageable)msg);
        MemoryBoundedQueueTest.assertTrue((boolean)true);
        queue.close();
    }

    public void testIsEmpty() {
        int size = 10;
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        for (int i = 0; i < size; ++i) {
            queue.enqueue((MemoryManageable)new ActiveMQMessage());
        }
        queue.clear();
        MemoryBoundedQueueTest.assertTrue((boolean)queue.isEmpty());
        queue.close();
    }

    public void testRemove() {
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        ActiveMQMessage msg = new ActiveMQMessage();
        queue.enqueue((MemoryManageable)msg);
        MemoryBoundedQueueTest.assertTrue((boolean)queue.remove((MemoryManageable)msg));
        queue.close();
    }

    public void testSize() {
        int size = 10;
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        for (int i = 0; i < size; ++i) {
            queue.enqueue((MemoryManageable)new ActiveMQMessage());
        }
        MemoryBoundedQueueTest.assertTrue((queue.size() == size ? 1 : 0) != 0);
        queue.close();
    }

    public void testRemovePacket() {
        int i;
        int size = 100;
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        ArrayList<ActiveMQMessage> list = new ArrayList<ActiveMQMessage>(size);
        for (i = 0; i < size; ++i) {
            ActiveMQMessage msg = new ActiveMQMessage();
            msg.setJMSMessageID("" + i);
            list.add(msg);
            queue.enqueue((MemoryManageable)msg);
        }
        for (i = 0; i < size; ++i) {
            queue.remove((MemoryManageable)((ActiveMQMessage)list.get(i)));
        }
        MemoryBoundedQueueTest.assertTrue((queue.size() == 0 ? 1 : 0) != 0);
        queue.close();
    }

    public void testRemovePacketById() {
        int i;
        int size = 100;
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue(QUEUE_NAME);
        ArrayList<ActiveMQMessage> list = new ArrayList<ActiveMQMessage>(size);
        for (i = 0; i < size; ++i) {
            ActiveMQMessage msg = new ActiveMQMessage();
            msg.setJMSMessageID("" + i);
            list.add(msg);
            queue.enqueue((MemoryManageable)msg);
        }
        for (i = 0; i < size; ++i) {
            ActiveMQMessage p = (ActiveMQMessage)list.get(i);
            MemoryManageable removed = queue.remove((Object)p.getJMSMessageID());
            MemoryBoundedQueueTest.assertTrue((removed != null ? 1 : 0) != 0);
            MemoryBoundedQueueTest.assertTrue((removed == p ? 1 : 0) != 0);
        }
        MemoryBoundedQueueTest.assertTrue((queue.size() == 0 ? 1 : 0) != 0);
        queue.close();
    }

    private class Dequeue
    implements Runnable {
        private MemoryBoundedQueue queue;
        private int localCount;

        Dequeue(MemoryBoundedQueue q, int num, int localCount) {
            this.queue = q;
            this.localCount = localCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                for (int internalCount = 0; internalCount < this.localCount; ++internalCount) {
                    Thread.yield();
                    MemoryManageable obj = this.queue.dequeue();
                    if (obj != null) continue;
                    break;
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            finally {
                MemoryBoundedQueueTest.this.stoppedSemaphore.release();
            }
        }
    }
}

