/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import org.activemq.io.util.MemoryBoundedQueue;
import org.activemq.io.util.MemoryBoundedQueueTest;
import org.activemq.io.util.MemoryManageable;
import org.activemq.message.ActiveMQMessage;

public class MemoryBoundedPrioritizedQueueTest
extends MemoryBoundedQueueTest {
    public void setUp() throws Exception {
        this.supportJMSPriority = true;
        super.setUp();
    }

    public void testMessagePriority() throws Exception {
        MemoryBoundedQueue queue = this.getQueueManager().getMemoryBoundedQueue("TestQueue");
        this.getMemoryManager().setValueLimit(6144L);
        ActiveMQMessage msg1 = new ActiveMQMessage();
        ActiveMQMessage msg2 = new ActiveMQMessage();
        msg2.setJMSPriority(2);
        ActiveMQMessage msg3 = new ActiveMQMessage();
        msg3.setJMSPriority(9);
        queue.enqueueNoBlock((MemoryManageable)msg1);
        queue.enqueueNoBlock((MemoryManageable)msg2);
        queue.enqueueNoBlock((MemoryManageable)msg3);
        MemoryManageable result1 = queue.dequeue();
        MemoryManageable result2 = queue.dequeue();
        MemoryManageable result3 = queue.dequeue();
        MemoryBoundedPrioritizedQueueTest.assertTrue((result1 == msg3 ? 1 : 0) != 0);
        MemoryBoundedPrioritizedQueueTest.assertTrue((result2 == msg1 ? 1 : 0) != 0);
        MemoryBoundedPrioritizedQueueTest.assertTrue((result3 == msg2 ? 1 : 0) != 0);
        queue.close();
    }
}

