/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import junit.framework.TestCase;
import org.activemq.io.util.MemoryBoundedMessageCache;
import org.activemq.io.util.MemoryBoundedObjectManager;
import org.activemq.message.ActiveMQMessage;

public class MemoryBoundedMessageCacheTest
extends TestCase {
    private static final int TEST_INSTANCE_SIZE = 2048;
    private final MemoryBoundedObjectManager memoryManager = new MemoryBoundedObjectManager("testmanager", 0x100000L);

    public void testMemoryGrowth() throws Exception {
        MemoryBoundedMessageCache cache = new MemoryBoundedMessageCache(this.memoryManager);
        this.memoryManager.setValueLimit(4096L);
        MemoryBoundedMessageCacheTest.assertEquals((long)0L, (long)this.memoryManager.getTotalMemoryUsedSize());
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setMemoryUsage(2048);
        cache.put("test", msg);
        ActiveMQMessage msg2 = new ActiveMQMessage();
        msg2.setMemoryUsage(2048);
        cache.put("test2", msg2);
        MemoryBoundedMessageCacheTest.assertNotNull((Object)cache.get("test"));
        MemoryBoundedMessageCacheTest.assertNotNull((Object)cache.get("test2"));
        MemoryBoundedMessageCacheTest.assertTrue((0L < this.memoryManager.getTotalMemoryUsedSize() ? 1 : 0) != 0);
        cache.remove("test");
        cache.remove("test2");
        MemoryBoundedMessageCacheTest.assertEquals((long)0L, (long)this.memoryManager.getTotalMemoryUsedSize());
    }

    public void testMemoryLimiting() throws Exception {
        MemoryBoundedMessageCache cache = new MemoryBoundedMessageCache(this.memoryManager);
        this.memoryManager.setValueLimit(1024L);
        MemoryBoundedMessageCacheTest.assertEquals((long)0L, (long)this.memoryManager.getTotalMemoryUsedSize());
        for (int i = 0; i < 10; ++i) {
            ActiveMQMessage msg = new ActiveMQMessage();
            msg.setMemoryUsage(2048);
            cache.put("first:" + i, msg);
        }
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setMemoryUsage(2048);
        cache.put("last", msg);
        MemoryBoundedMessageCacheTest.assertNull((Object)cache.get("first:9"));
        MemoryBoundedMessageCacheTest.assertNotNull((Object)cache.get("last"));
        MemoryBoundedMessageCacheTest.assertTrue((0L < this.memoryManager.getTotalMemoryUsedSize() ? 1 : 0) != 0);
        cache.remove("last");
        MemoryBoundedMessageCacheTest.assertEquals((long)0L, (long)this.memoryManager.getTotalMemoryUsedSize());
    }
}

